/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.entity;

import com.mojang.math.Vector3f;
import gdavid.phi.util.IWaveImpacted;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.spell.ISpellImmune;

public class PsionWaveEntity
extends ThrowableProjectile
implements ISpellImmune {
    public static final String id = "psion_wave";
    @ObjectHolder(registryName="entity_type", value="phi:psion_wave")
    public static EntityType<PsionWaveEntity> type;
    static final String tagColorizer = "colorizer";
    static final String tagShooter = "shooter";
    static final String tagDirectionX = "direction_x";
    static final String tagDirectionY = "direction_y";
    static final String tagDirectionZ = "direction_z";
    static final String tagSpeed = "speed";
    static final String tagFrequency = "frequency";
    static final String tagDistance = "distance";
    static final String tagTraveled = "traveled";
    public static final EntityDataAccessor<ItemStack> colorizer;
    public static final EntityDataAccessor<Optional<UUID>> shooter;
    public static final EntityDataAccessor<Float> directionX;
    public static final EntityDataAccessor<Float> directionY;
    public static final EntityDataAccessor<Float> directionZ;
    public static final EntityDataAccessor<Float> speed;
    public static final EntityDataAccessor<Float> frequency;
    public static final EntityDataAccessor<Float> distance;
    public static final EntityDataAccessor<Float> traveled;

    public PsionWaveEntity(EntityType<PsionWaveEntity> type, Level world) {
        super(type, world);
    }

    public PsionWaveEntity(Level world, Vector3f direction, float speed, float frequency, float distance) {
        super(type, world);
        this.f_19804_.m_135381_(directionX, (Object)Float.valueOf(direction.m_122239_()));
        this.f_19804_.m_135381_(directionY, (Object)Float.valueOf(direction.m_122260_()));
        this.f_19804_.m_135381_(directionZ, (Object)Float.valueOf(direction.m_122269_()));
        this.f_19804_.m_135381_(PsionWaveEntity.speed, (Object)Float.valueOf(speed));
        this.f_19804_.m_135381_(PsionWaveEntity.frequency, (Object)Float.valueOf(frequency));
        this.f_19804_.m_135381_(PsionWaveEntity.distance, (Object)Float.valueOf(distance));
    }

    public void m_5602_(Entity entity) {
        super.m_5602_(entity);
        this.f_19804_.m_135381_(shooter, Optional.of(entity.m_20148_()));
    }

    public void setColorizer(ItemStack stack) {
        this.f_19804_.m_135381_(colorizer, (Object)stack);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(colorizer, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(shooter, Optional.of(new UUID(0L, 0L)));
        this.f_19804_.m_135372_(directionX, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(directionY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(directionZ, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(speed, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(frequency, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(distance, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(traveled, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ItemStack colorizerItem = (ItemStack)this.f_19804_.m_135370_(colorizer);
        if (!colorizerItem.m_41619_()) {
            nbt.m_128365_(tagColorizer, (Tag)colorizerItem.m_41739_(new CompoundTag()));
        }
        nbt.m_128362_(tagShooter, (UUID)((Optional)this.f_19804_.m_135370_(shooter)).get());
        nbt.m_128350_(tagDirectionX, ((Float)this.f_19804_.m_135370_(directionX)).floatValue());
        nbt.m_128350_(tagDirectionY, ((Float)this.f_19804_.m_135370_(directionY)).floatValue());
        nbt.m_128350_(tagDirectionZ, ((Float)this.f_19804_.m_135370_(directionZ)).floatValue());
        nbt.m_128350_(tagSpeed, ((Float)this.f_19804_.m_135370_(speed)).floatValue());
        nbt.m_128350_(tagFrequency, ((Float)this.f_19804_.m_135370_(frequency)).floatValue());
        nbt.m_128350_(tagDistance, ((Float)this.f_19804_.m_135370_(distance)).floatValue());
        nbt.m_128350_(tagTraveled, ((Float)this.f_19804_.m_135370_(traveled)).floatValue());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(colorizer, (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_(tagColorizer)));
        this.f_19804_.m_135381_(shooter, Optional.of(nbt.m_128342_(tagShooter)));
        this.f_19804_.m_135381_(directionX, (Object)Float.valueOf(nbt.m_128457_(tagDirectionX)));
        this.f_19804_.m_135381_(directionY, (Object)Float.valueOf(nbt.m_128457_(tagDirectionY)));
        this.f_19804_.m_135381_(directionZ, (Object)Float.valueOf(nbt.m_128457_(tagDirectionZ)));
        this.f_19804_.m_135381_(speed, (Object)Float.valueOf(nbt.m_128457_(tagSpeed)));
        this.f_19804_.m_135381_(frequency, (Object)Float.valueOf(nbt.m_128457_(tagFrequency)));
        this.f_19804_.m_135381_(distance, (Object)Float.valueOf(nbt.m_128457_(tagDistance)));
        this.f_19804_.m_135381_(traveled, (Object)Float.valueOf(nbt.m_128457_(tagTraveled)));
    }

    public void m_8119_() {
        this.m_20334_(((Float)this.f_19804_.m_135370_(directionX)).floatValue() * ((Float)this.f_19804_.m_135370_(speed)).floatValue() / 40.0f, ((Float)this.f_19804_.m_135370_(directionY)).floatValue() * ((Float)this.f_19804_.m_135370_(speed)).floatValue() / 40.0f, ((Float)this.f_19804_.m_135370_(directionZ)).floatValue() * ((Float)this.f_19804_.m_135370_(speed)).floatValue() / 40.0f);
        super.m_8119_();
        this.f_19804_.m_135381_(traveled, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(traveled)).floatValue() + ((Float)this.f_19804_.m_135370_(speed)).floatValue() / 40.0f));
        if (((Float)this.f_19804_.m_135370_(traveled)).floatValue() > ((Float)this.f_19804_.m_135370_(distance)).floatValue()) {
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult result) {
        BlockEntity tile;
        float traveledPercent = ((Float)this.f_19804_.m_135370_(traveled)).floatValue() / ((Float)this.f_19804_.m_135370_(distance)).floatValue();
        float focus = 2.0f * traveledPercent * (traveledPercent - 1.0f) + 1.0f;
        if (result instanceof EntityHitResult) {
            Entity hit = ((EntityHitResult)result).m_82443_();
            if (hit.m_20148_().equals(((Optional)this.f_19804_.m_135370_(shooter)).get()) && (double)((Float)this.f_19804_.m_135370_(traveled)).floatValue() < 0.8) {
                return;
            }
            if (hit instanceof Player && !this.f_19853_.f_46443_) {
                Player player = (Player)hit;
                IPlayerData data = PsiAPI.internalHandler.getDataForPlayer(player);
                data.deductPsi((int)Math.ceil(((Float)this.f_19804_.m_135370_(frequency)).floatValue() * 10.0f * focus), (int)Math.ceil(((Float)this.f_19804_.m_135370_(frequency)).floatValue() * 2.0f * focus), true, true);
                MobEffectInstance effect = player.m_21124_(MobEffects.f_19597_);
                int newTime = effect == null ? (int)Math.ceil(((Float)this.f_19804_.m_135370_(frequency)).floatValue() * focus) : (int)Math.ceil(Math.pow(((Float)this.f_19804_.m_135370_(frequency)).floatValue() * focus + (float)effect.m_19557_(), 1.0 + 0.2 * (double)focus));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, newTime % 600, newTime / 60, false, false));
            }
            this.m_146870_();
        } else if (result instanceof BlockHitResult && (tile = this.f_19853_.m_7702_(((BlockHitResult)result).m_82425_())) instanceof IWaveImpacted) {
            ((IWaveImpacted)tile).waveImpact((Float)this.f_19804_.m_135370_(frequency), focus);
            this.m_146870_();
        }
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public boolean m_6090_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean isImmune() {
        return true;
    }

    static {
        colorizer = SynchedEntityData.m_135353_(PsionWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        shooter = SynchedEntityData.m_135353_(PsionWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        directionX = SynchedEntityData.m_135353_(PsionWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        directionY = SynchedEntityData.m_135353_(PsionWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        directionZ = SynchedEntityData.m_135353_(PsionWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        speed = SynchedEntityData.m_135353_(PsionWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        frequency = SynchedEntityData.m_135353_(PsionWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        distance = SynchedEntityData.m_135353_(PsionWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        traveled = SynchedEntityData.m_135353_(PsionWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

