/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.entity.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import gdavid.phi.entity.PsionWaveEntity;
import gdavid.phi.util.RenderHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PsionWaveRenderer
extends EntityRenderer<PsionWaveEntity> {
    static final RenderType layer = RenderType.m_173215_((String)"phi:psion_wave", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1440, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("psi", "textures/particle/wisp.png"), false, false)).m_110661_(new RenderStateShard.CullStateShard(false)).m_173292_(RenderStateShard.f_173101_).m_110685_(new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    })).m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110691_(true));

    public PsionWaveRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(PsionWaveEntity entity, float entityYaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light) {
        SynchedEntityData dm = entity.m_20088_();
        ItemStack colorizer = (ItemStack)dm.m_135370_(PsionWaveEntity.colorizer);
        int color = RenderHelper.getColorForColorizer(colorizer);
        int r = RenderHelper.r(color);
        int g = RenderHelper.g(color);
        int b = RenderHelper.b(color);
        VertexConsumer buffer = buffers.m_6299_(layer);
        int fullbright = 0xF000F0;
        Quaternion rotation = Vector3f.f_122225_.m_122240_(entity.m_146908_());
        rotation.m_80148_(Vector3f.f_122222_.m_122240_(entity.m_146909_()));
        float traveledPercent = ((Float)dm.m_135370_(PsionWaveEntity.traveled)).floatValue() / ((Float)dm.m_135370_(PsionWaveEntity.distance)).floatValue();
        float size = 4.0f * traveledPercent * (1.0f - traveledPercent);
        size = (float)((double)size + Math.sin(((Float)dm.m_135370_(PsionWaveEntity.frequency)).floatValue() * ((Float)dm.m_135370_(PsionWaveEntity.traveled)).floatValue() / ((Float)dm.m_135370_(PsionWaveEntity.speed)).floatValue()) * (double)size / 20.0);
        int particleCount = 90;
        for (float angle = 0.0f; angle < 360.0f; angle += 360.0f / (float)particleCount) {
            Vector3f pos = new Vector3f(0.0f, size / 2.0f, 0.0f);
            pos.m_122251_(Vector3f.f_122226_.m_122240_(angle));
            pos.m_122251_(rotation);
            pos.m_122272_(0.0f, 0.5f, 0.0f);
            this.particle(buffer, ms, fullbright, r, g, b, pos, 0.05f);
        }
    }

    void particle(VertexConsumer buffer, PoseStack ms, int light, int r, int g, int b, Vector3f pos, float size) {
        float halfSize = size / 2.0f;
        ms.m_85836_();
        ms.m_85837_((double)pos.m_122239_(), (double)pos.m_122260_(), (double)pos.m_122269_());
        ms.m_85845_(this.f_114476_.m_114470_());
        ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        Matrix4f mat = ms.m_85850_().m_85861_();
        buffer.m_85982_(mat, -halfSize, halfSize, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, halfSize, halfSize, 0.0f).m_6122_(r, g, b, 255).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, halfSize, -halfSize, 0.0f).m_6122_(r, g, b, 255).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, -halfSize, -halfSize, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
        ms.m_85849_();
    }

    public ResourceLocation getTextureLocation(PsionWaveEntity entity) {
        return null;
    }
}

