/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import gdavid.phi.gui.widget.SlotSelectWidget;
import gdavid.phi.network.Messages;
import gdavid.phi.network.ProgramTransferMessage;
import gdavid.phi.util.IProgramTransferTarget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.client.gui.GuiProgrammer;

@OnlyIn(value=Dist.CLIENT)
public class ProgramTransferWidget
extends AbstractWidget {
    static final ResourceLocation texture = new ResourceLocation("phi", "textures/gui/program_transfer.png");
    final GuiProgrammer parent;
    final IProgramTransferTarget holder;
    final Direction dir;
    final boolean mirror;
    public final SlotSelectWidget select;

    public ProgramTransferWidget(GuiProgrammer parent, IProgramTransferTarget holder, boolean side, Direction dir) {
        super(parent.left + (side ? parent.xSize - 54 : 0), parent.top + parent.ySize + 12, 54, 16, (Component)Component.m_237119_());
        this.parent = parent;
        this.holder = holder;
        this.dir = dir;
        this.mirror = side;
        this.select = new SlotSelectWidget(parent, this, holder, side, dir);
    }

    public void m_6303_(PoseStack ms, int mouseX, int mouseY, float partial) {
        if (this.parent.takingScreenshot) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        this.drawButton(mouseX, mouseY, ms, 0, 0, 0);
        if (this.clickButton(mouseX, mouseY, 0, 0)) {
            this.parent.tooltip.add(Component.m_237115_((String)"phi.program_transfer.write"));
        }
        this.drawButton(mouseX, mouseY, ms, 19, 0, 1);
        if (this.clickButton(mouseX, mouseY, 19, 0)) {
            this.parent.tooltip.add(Component.m_237115_((String)"phi.program_transfer.read"));
        }
        if (this.holder.hasSlots()) {
            this.drawButton(mouseX, mouseY, ms, 38, 0, 2, this.select.f_93623_);
            if (this.clickButton(mouseX, mouseY, 38, 0)) {
                this.parent.tooltip.add(Component.m_237115_((String)"phi.program_transfer.select_slot"));
            }
        }
    }

    public void m_5716_(double x, double y) {
        if (this.clickButton(x, y, 0, 0)) {
            Messages.channel.sendToServer((Object)new ProgramTransferMessage(this.parent.programmer.m_58899_(), this.dir));
        } else if (this.clickButton(x, y, 19, 0)) {
            Messages.channel.sendToServer((Object)new ProgramTransferMessage(this.holder.getPosition(), this.dir.m_122424_()));
        } else if (this.holder.hasSlots() && this.clickButton(x, y, 38, 0)) {
            this.select.show();
        }
    }

    void drawButton(int mx, int my, PoseStack ms, int x, int y, int id) {
        this.drawButton(mx, my, ms, x, y, id, false);
    }

    void drawButton(int mx, int my, PoseStack ms, int x, int y, int id, boolean pressed) {
        if (this.mirror) {
            x = 54 - x - 16;
        }
        ProgramTransferWidget.m_93133_((PoseStack)ms, (int)(this.f_93620_ + x), (int)(this.f_93621_ + y), (float)(16 * id), (float)(pressed ? 16.0f : (float)this.highlight(mx, my, x, y, 16, 16)), (int)16, (int)16, (int)64, (int)32);
    }

    boolean clickButton(double mx, double my, int x, int y) {
        return this.checkMouse(mx, my, this.mirror ? 54 - x - 16 : x, y, 16, 16);
    }

    int highlight(int mx, int my, int x, int y, int w, int h) {
        return this.checkMouse(mx, my, x, y, w, h) ? 16 : 0;
    }

    boolean checkMouse(double mx, double my, int x, int y, int w, int h) {
        return !this.select.f_93623_ && mx >= (double)(this.f_93620_ + x) && mx < (double)(this.f_93620_ + x + w) && my >= (double)(this.f_93621_ + y) && my < (double)(this.f_93621_ + y + h);
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }
}

