/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.gui.widget;

import com.google.common.collect.Streams;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import gdavid.phi.gui.widget.ProgramTransferWidget;
import gdavid.phi.network.Messages;
import gdavid.phi.network.ProgramTransferSlotMessage;
import gdavid.phi.util.IProgramTransferTarget;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.psi.client.gui.GuiProgrammer;

@OnlyIn(value=Dist.CLIENT)
public class SlotSelectWidget
extends AbstractWidget {
    static final ResourceLocation texture = new ResourceLocation("phi", "textures/gui/program_transfer.png");
    static final int[] px = new int[]{30, 27, 11, -8, -27, -43, -46, -43, -27, -8, 11, 27};
    static final int[] py = new int[]{-8, 11, 27, 30, 27, 11, -8, -27, -43, -46, -43, -27};
    final GuiProgrammer parent;
    final ProgramTransferWidget transfer;
    final IProgramTransferTarget holder;
    final Direction dir;

    public SlotSelectWidget(GuiProgrammer parent, ProgramTransferWidget transfer, IProgramTransferTarget holder, boolean side, Direction dir) {
        super(parent.left + (side ? parent.xSize - 92 : 0), parent.top + parent.ySize - 26, 92, 92, (Component)Component.m_237119_());
        this.parent = parent;
        this.transfer = transfer;
        this.holder = holder;
        this.dir = dir;
        this.hide();
    }

    public void m_6303_(PoseStack ms, int mouseX, int mouseY, float partial) {
        if (this.parent.takingScreenshot) {
            return;
        }
        List<Integer> slots = this.holder.getSlots();
        List<ResourceLocation> icons = this.holder.getSlotIcons();
        if ((Integer)slots.stream().max(Integer::compare).get() >= 12 || (Integer)slots.stream().min(Integer::compare).get() < 0) {
            int i = 0;
            for (ResourceLocation icon : icons) {
                int x = 19 * (i % 5);
                int y = 19 * (i / 5);
                RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
                this.drawButton(mouseX, mouseY, ms, x, y, 3);
                RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
                SlotSelectWidget.m_93133_((PoseStack)ms, (int)(this.f_93620_ + x), (int)(this.f_93621_ + y), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                ++i;
            }
        } else {
            Streams.zip(slots.stream(), icons.stream(), Pair::of).forEach(elem -> {
                int i = (Integer)elem.getLeft();
                int x = px[i] + 46;
                int y = py[i] + 46;
                RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
                this.drawButton(mouseX, mouseY, ms, x, y, 3);
                RenderSystem.m_157456_((int)0, (ResourceLocation)((ResourceLocation)elem.getRight()));
                SlotSelectWidget.m_93133_((PoseStack)ms, (int)(this.f_93620_ + x), (int)(this.f_93621_ + y), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            });
        }
    }

    public void m_5716_(double mx, double my) {
        List<Integer> slots = this.holder.getSlots();
        if ((Integer)slots.stream().max(Integer::compare).get() >= 12 || (Integer)slots.stream().min(Integer::compare).get() < 0) {
            int i = 0;
            for (int slot : slots) {
                int x = 19 * (i % 5);
                int y = 19 * (i / 5);
                if (this.clickButton(mx, my, x, y)) {
                    this.select(slot);
                }
                ++i;
            }
        } else {
            for (int slot : slots) {
                int y;
                int x = px[slot] + 46;
                if (!this.clickButton(mx, my, x, y = py[slot] + 46)) continue;
                this.select(slot);
            }
        }
        this.hide();
    }

    public void show() {
        this.f_93623_ = true;
        this.f_93624_ = true;
        this.transfer.f_93623_ = false;
    }

    public void hide() {
        this.f_93623_ = false;
        this.f_93624_ = false;
        this.transfer.f_93623_ = true;
    }

    void select(int slot) {
        Messages.channel.sendToServer((Object)new ProgramTransferSlotMessage(this.holder.getPosition(), slot));
    }

    void drawButton(int mx, int my, PoseStack ms, int x, int y, int id) {
        SlotSelectWidget.m_93133_((PoseStack)ms, (int)(this.f_93620_ + x), (int)(this.f_93621_ + y), (float)(16 * id), (float)this.highlight(mx, my, x, y, 16, 16), (int)16, (int)16, (int)64, (int)32);
    }

    boolean clickButton(double mx, double my, int x, int y) {
        return this.checkMouse(mx, my, x, y, 16, 16);
    }

    int highlight(int mx, int my, int x, int y, int w, int h) {
        return this.checkMouse(mx, my, x, y, w, h) ? 16 : 0;
    }

    boolean checkMouse(double mx, double my, int x, int y, int w, int h) {
        return mx >= (double)(this.f_93620_ + x) && mx < (double)(this.f_93620_ + x + w) && my >= (double)(this.f_93621_ + y) && my < (double)(this.f_93621_ + y + h);
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }
}

