/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.item;

import gdavid.phi.capability.MPUCADData;
import gdavid.phi.spell.Errors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.piece.PieceCraftingTrick;

public class MPUCAD
extends Item
implements ICAD {
    public static final String id = "mpu.cad";
    public static final MPUCAD instance = new MPUCAD();
    public static int savedVectors = 1;

    private MPUCAD() {
        super(new Item.Properties());
    }

    public ICADData getData(ItemStack stack) {
        return (ICADData)stack.getCapability(PsiAPI.CAD_DATA_CAPABILITY).orElseGet(() -> new MPUCADData(stack));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        MPUCADData data = new MPUCADData(stack);
        if (nbt != null) {
            data.deserializeNBT(nbt);
        }
        return data;
    }

    public ItemStack getComponentInSlot(ItemStack stack, EnumCADComponent type) {
        return ItemStack.f_41583_;
    }

    public int getStatValue(ItemStack stack, EnumCADStat stat) {
        if (stat == EnumCADStat.EFFICIENCY) {
            return 100;
        }
        if (stat == EnumCADStat.POTENCY) {
            return 80;
        }
        if (stat == EnumCADStat.COMPLEXITY) {
            return 40;
        }
        if (stat == EnumCADStat.PROJECTION) {
            return 3;
        }
        if (stat == EnumCADStat.BANDWIDTH) {
            return 9;
        }
        if (stat == EnumCADStat.SAVED_VECTORS) {
            return savedVectors;
        }
        return 0;
    }

    public int getStoredPsi(ItemStack stack) {
        return 0;
    }

    public void regenPsi(ItemStack stack, int psi) {
    }

    public int consumePsi(ItemStack stack, int psi) {
        return psi;
    }

    public int getMemorySize(ItemStack stack) {
        return savedVectors;
    }

    public void setStoredVector(ItemStack stack, int memorySlot, Vector3 vec) throws SpellRuntimeException {
        if (memorySlot < 0 || memorySlot >= savedVectors) {
            Errors.runtime("psi.spellerror.memoryoutofbounds");
        }
        this.getData(stack).setSavedVector(memorySlot, vec);
    }

    public Vector3 getStoredVector(ItemStack stack, int memorySlot) throws SpellRuntimeException {
        if (memorySlot < 0 || memorySlot >= savedVectors) {
            Errors.runtime("psi.spellerror.memoryoutofbounds");
        }
        return this.getData(stack).getSavedVector(memorySlot);
    }

    public int getTime(ItemStack stack) {
        return this.getData(stack).getTime();
    }

    public void setTime(ItemStack stack, int time) {
        ICADData data = this.getData(stack);
        data.setTime(time);
    }

    public void incrementTime(ItemStack stack) {
        ICADData data = this.getData(stack);
        data.setTime(data.getTime() + 1);
    }

    public int getSpellColor(ItemStack stack) {
        return 1295871;
    }

    public boolean craft(ItemStack cad, Player entity, PieceCraftingTrick trick) {
        return false;
    }
}

