/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.item;

import gdavid.phi.capability.MagazineSocketable;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.CADTakeEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.SpellRuntimeException;

@Mod.EventBusSubscriber
public class SpellMagazineItem
extends Item
implements ICADComponent {
    public static final String tagSlot = "slot";
    public static final String tagVector = "vector";
    public final String id;
    public int bandwidth;
    public int sockets;
    public int vectors;

    public SpellMagazineItem(String id, int sockets, int bandwidth, int vectors) {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_));
        this.id = id;
        this.bandwidth = bandwidth;
        this.sockets = sockets;
        this.vectors = vectors;
    }

    public EnumCADComponent getComponentType(ItemStack stack) {
        return EnumCADComponent.SOCKET;
    }

    public int getCADStatValue(ItemStack stack, EnumCADStat stat) {
        if (stat == EnumCADStat.BANDWIDTH) {
            return this.bandwidth;
        }
        if (stat == EnumCADStat.SOCKETS) {
            return this.sockets;
        }
        if (stat == EnumCADStat.SAVED_VECTORS) {
            return this.vectors;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack item, Level world, List<Component> tooltip, TooltipFlag advanced) {
        int i;
        ISocketable socket = ISocketable.socketable((ItemStack)item);
        tooltip.add((Component)Component.m_237115_((String)("item.phi." + this.id + ".desc")));
        tooltip.add((Component)Component.m_237115_((String)"item.phi.spell_magazine.desc"));
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)EnumCADStat.BANDWIDTH.getName()).m_130940_(ChatFormatting.AQUA)).m_130946_(": " + this.bandwidth));
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)EnumCADStat.SOCKETS.getName()).m_130940_(ChatFormatting.AQUA)).m_130946_(": " + this.sockets));
        for (i = 0; i < this.sockets; ++i) {
            ItemStack bullet = socket.getBulletInSocket(i);
            if (bullet.m_41619_()) {
                tooltip.add((Component)Component.m_237113_((String)" - [Empty]").m_130940_(ChatFormatting.GRAY));
                continue;
            }
            tooltip.add((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY).m_7220_(socket.getBulletInSocket(i).m_41786_()));
        }
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)EnumCADStat.SAVED_VECTORS.getName()).m_130940_(ChatFormatting.AQUA)).m_130946_(": " + this.vectors));
        for (i = 0; i < this.vectors; ++i) {
            Vector3 vector = this.getStoredVector(item, i);
            if (vector.isZero()) continue;
            tooltip.add((Component)Component.m_237113_((String)(" " + (i + 1) + ": [")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)Double.toString(vector.x)).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)Double.toString(vector.y)).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)Double.toString(vector.z)).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.GRAY)));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack item, CompoundTag nbt) {
        return new MagazineSocketable(item, this.sockets);
    }

    @SubscribeEvent
    public static void TakeCAD(CADTakeEvent e) {
        ItemStack socket = e.getAssembler().getStackForComponent(EnumCADComponent.SOCKET);
        if (socket.m_41720_() instanceof SpellMagazineItem) {
            ((SpellMagazineItem)socket.m_41720_()).insertMag(socket.m_41777_(), e.getCad());
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        ItemStack cad = PsiAPI.getPlayerCAD((Player)player);
        ItemStack old = SpellMagazineItem.ejectMag(cad);
        if (old.m_41619_()) {
            return InteractionResultHolder.m_19100_((Object)item);
        }
        if (!world.f_46443_) {
            this.insertMag(item, cad);
        }
        return InteractionResultHolder.m_19096_((Object)old);
    }

    public static ItemStack ejectMag(ItemStack cad) {
        if (!(cad.m_41720_() instanceof ICAD) || !ISocketable.isSocketable((ItemStack)cad)) {
            return ItemStack.f_41583_;
        }
        ICAD cadItem = (ICAD)cad.m_41720_();
        ItemStack socketStack = cadItem.getComponentInSlot(cad, EnumCADComponent.SOCKET).m_41777_();
        if (!(socketStack.m_41720_() instanceof SpellMagazineItem)) {
            return ItemStack.f_41583_;
        }
        ((SpellMagazineItem)socketStack.m_41720_()).fromCad(cad, socketStack);
        return socketStack;
    }

    public void fromCad(ItemStack cad, ItemStack mag) {
        int i;
        if (!(cad.m_41720_() instanceof ICAD) || !ISocketable.isSocketable((ItemStack)cad)) {
            return;
        }
        ICAD cadItem = (ICAD)cad.m_41720_();
        ISocketable socket = ISocketable.socketable((ItemStack)cad);
        ISocketable contents = ISocketable.socketable((ItemStack)mag);
        for (i = 0; i < this.sockets; ++i) {
            contents.setBulletInSocket(i, socket.getBulletInSocket(i));
        }
        for (i = 0; i < this.vectors; ++i) {
            try {
                this.setStoredVector(mag, i, cadItem.getStoredVector(cad, i));
                continue;
            }
            catch (SpellRuntimeException spellRuntimeException) {
                // empty catch block
            }
        }
    }

    public void insertMag(ItemStack mag, ItemStack cad) {
        int i;
        if (!(cad.m_41720_() instanceof ICAD) || !ISocketable.isSocketable((ItemStack)cad)) {
            return;
        }
        ICAD cadItem = (ICAD)cad.m_41720_();
        ISocketable socket = ISocketable.socketable((ItemStack)cad);
        for (int i2 = this.sockets; i2 < 12; ++i2) {
            socket.setBulletInSocket(i2, ItemStack.f_41583_);
        }
        cadItem.setCADComponent(cad, mag);
        ISocketable contents = ISocketable.socketable((ItemStack)mag);
        for (i = 0; i < this.sockets; ++i) {
            socket.setBulletInSocket(i, contents.getBulletInSocket(i));
        }
        for (i = 0; i < this.vectors; ++i) {
            try {
                cadItem.setStoredVector(cad, i, this.getStoredVector(mag, i));
                continue;
            }
            catch (SpellRuntimeException spellRuntimeException) {
                // empty catch block
            }
        }
        this.stripCadData(mag);
        cadItem.setCADComponent(cad, mag);
    }

    public void stripCadData(ItemStack item) {
        item.m_41749_(tagVector);
        item.m_41749_(tagSlot);
    }

    public Vector3 getStoredVector(ItemStack item, int slot) {
        CompoundTag nbt = item.m_41698_(tagVector);
        return new Vector3(nbt.m_128459_(slot + "_x"), nbt.m_128459_(slot + "_y"), nbt.m_128459_(slot + "_z"));
    }

    public void setStoredVector(ItemStack item, int slot, Vector3 vec) {
        CompoundTag nbt = item.m_41698_(tagVector);
        nbt.m_128347_(slot + "_x", vec.x);
        nbt.m_128347_(slot + "_y", vec.y);
        nbt.m_128347_(slot + "_z", vec.z);
    }
}

