/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.item;

import gdavid.phi.entity.SpiritEntity;
import gdavid.phi.util.RenderHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class SpiritSummoningTalismanItem
extends Item {
    public final String id;
    static final String tagUuid = "uuid";

    public SpiritSummoningTalismanItem(String id) {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_));
        this.id = id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack item, Level world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.m_237115_((String)("item.phi." + this.id + ".desc")));
    }

    public int getMinDuration(ItemStack stack) {
        return 40;
    }

    public int m_8105_(ItemStack stack) {
        return 141;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (world instanceof ServerLevel) {
            SpiritEntity spirit = this.getSpirit(item, (ServerLevel)world);
            if (spirit != null && spirit.f_19797_ < 60) {
                return InteractionResultHolder.m_19098_((Object)item);
            }
            player.m_6672_(hand);
        }
        return InteractionResultHolder.m_19090_((Object)item);
    }

    public void m_5929_(Level world, LivingEntity player, ItemStack stack, int count) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)((Player)player));
        if (data.overflowed) {
            player.m_21253_();
            return;
        }
        data.deductPsi(25, 20, true);
        if (world.f_46443_) {
            Vec3 pos = player.m_20182_().m_82549_(player.m_20154_().m_82490_(1.5)).m_82520_(0.0, (double)player.m_20192_(), 0.0);
            ItemStack cad = PsiAPI.getPlayerCAD((Player)((Player)player));
            int color = 1295871;
            if (!cad.m_41619_()) {
                ItemStack colorizer = ((ICAD)cad.m_41720_()).getComponentInSlot(cad, EnumCADComponent.DYE);
                color = RenderHelper.getColorForColorizer(colorizer);
            }
            int r = RenderHelper.r(color);
            int g = RenderHelper.g(color);
            int b = RenderHelper.b(color);
            if (this.m_8105_(stack) - count >= this.getMinDuration(stack)) {
                Psi.proxy.sparkleFX(pos.f_82479_, pos.f_82480_, pos.f_82481_, (float)(r / 2), (float)(g / 2), (float)(b / 2), 0.0f, 0.0f, 0.0f, 2.75f, 15);
            }
            Vec3 dir = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82490_(0.1);
            pos = pos.m_82546_(dir.m_82490_(10.0));
            Psi.proxy.sparkleFX(pos.f_82479_, pos.f_82480_, pos.f_82481_, (float)r, (float)g, (float)b, (float)dir.f_82479_, (float)dir.f_82480_, (float)dir.f_82481_, 1.2f, 15);
        }
        if (count == 1) {
            player.m_21253_();
        }
    }

    public void m_5551_(ItemStack item, Level world, LivingEntity player, int timeLeft) {
        int duration = this.m_8105_(item) - timeLeft;
        if (duration < this.getMinDuration(item)) {
            PlayerDataHandler.get((Player)((Player)player)).deductPsi(-25 * duration, 0, true);
            return;
        }
        if (!(world instanceof ServerLevel)) {
            return;
        }
        SpiritEntity spirit = new SpiritEntity(world, (Entity)player, (duration - 20) * 150);
        Vec3 pos = player.m_20182_().m_82549_(player.m_20154_().m_82490_(1.5)).m_82520_(0.0, (double)player.m_20192_() - 0.25, 0.0);
        spirit.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        world.m_7967_((Entity)spirit);
        this.setSpirit(item, (ServerLevel)world, spirit);
    }

    public SpiritEntity getSpirit(ItemStack item, ServerLevel world) {
        if (!item.m_41784_().m_128441_(tagUuid)) {
            return null;
        }
        CompoundTag nbt = item.m_41784_();
        Entity entity = world.m_8791_(nbt.m_128342_(tagUuid));
        if (entity instanceof SpiritEntity) {
            return (SpiritEntity)entity;
        }
        return null;
    }

    public void setSpirit(ItemStack item, ServerLevel world, SpiritEntity spirit) {
        SpiritEntity prev = this.getSpirit(item, world);
        if (prev != null) {
            prev.m_146870_();
        }
        item.m_41784_().m_128362_(tagUuid, spirit.m_20148_());
    }
}

