/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.mixin;

import gdavid.phi.spell.error.PropagatingSpellRuntimeException;
import gdavid.phi.spell.param.ErrorParam;
import gdavid.phi.util.ISidedResult;
import java.util.Map;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;

@Mixin(value={SpellPiece.class}, remap=false)
public class SpellPieceMixin {
    @Shadow
    @Final
    public Map<SpellParam<?>, SpellParam.Side> paramSides;
    @Shadow
    @Final
    public Spell spell;
    @Shadow
    public int x;
    @Shadow
    public int y;

    @Inject(method={"getRawParamValue"}, at={@At(value="RETURN")}, cancellable=true)
    private void getRawParamValue(SpellContext context, SpellParam<?> param, CallbackInfoReturnable<Object> callback) throws SpellRuntimeException {
        SpellParam.Side side;
        Object res = callback.getReturnValue();
        if (res instanceof PropagatingSpellRuntimeException && !(param instanceof ErrorParam)) {
            SpellPiece self = (SpellPiece)this;
            boolean suppress = context.cspell.metadata.getFlag(PropagatingSpellRuntimeException.suppressFlag(self));
            ((PropagatingSpellRuntimeException)((Object)res)).rethrow(self.getPieceType().isTrick() && !suppress);
        }
        if (!(side = this.paramSides.get(param)).isEnabled()) {
            return;
        }
        if (res instanceof ISidedResult) {
            try {
                SpellPiece[] piece = new SpellPiece[]{(SpellPiece)this};
                SpellPiece target = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, side, p -> {
                    piece[0] = p;
                });
                for (SpellParam.Side s : SpellParam.Side.values()) {
                    if (s.offx != piece[0].x - target.x || s.offy != piece[0].y - target.y) continue;
                    callback.setReturnValue(((ISidedResult)res).get(s));
                    break;
                }
            }
            catch (SpellCompilationException spellCompilationException) {
                // empty catch block
            }
        }
    }
}

