/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.network;

import gdavid.phi.capability.ModCapabilities;
import gdavid.phi.network.Message;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import vazkii.psi.api.internal.Vector3;

public class GravityMessage
implements Message {
    final double x;
    final double y;
    final double z;
    final double power;
    final int duration;

    public GravityMessage(Vector3 vec, double power, int duration) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        this.power = power;
        this.duration = duration;
    }

    public GravityMessage(FriendlyByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.power = buf.readDouble();
        this.duration = buf.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.power);
        buf.writeInt(this.duration);
    }

    @Override
    public boolean receive(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_.getCapability(ModCapabilities.acceleration).ifPresent(cap -> cap.addAccelerationTowardsPoint(new Vector3(this.x, this.y, this.z), this.power, this.duration))));
        return true;
    }
}

