/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.network;

import gdavid.phi.network.Message;
import gdavid.phi.util.IProgramTransferTarget;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import vazkii.psi.api.internal.VanillaPacketDispatcher;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.block.tile.TileProgrammer;

public class ProgramTransferMessage
implements Message {
    final BlockPos pos;
    final Direction dir;

    public ProgramTransferMessage(BlockPos pos, Direction dir) {
        this.pos = pos;
        this.dir = dir;
    }

    public ProgramTransferMessage(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.dir = Direction.m_122376_((int)buf.readInt());
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.dir.m_122411_());
    }

    @Override
    public boolean receive(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Object spell;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            BlockEntity a = player.f_19853_.m_7702_(this.pos);
            BlockEntity b = player.f_19853_.m_7702_(this.pos.m_121945_(this.dir));
            if (a instanceof TileProgrammer) {
                Spell tmp = ((TileProgrammer)a).spell;
                spell = tmp != null ? tmp.copy() : null;
            } else if (a instanceof IProgramTransferTarget) {
                spell = ((IProgramTransferTarget)a).getSpell();
            } else {
                return;
            }
            if (spell != null) {
                spell.uuid = UUID.randomUUID();
            }
            if (b instanceof TileProgrammer) {
                ((TileProgrammer)b).spell = spell;
                ((TileProgrammer)b).onSpellChanged();
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)b);
            } else if (b instanceof IProgramTransferTarget) {
                ((IProgramTransferTarget)b).setSpell((Player)player, (Spell)spell);
            }
        });
        return true;
    }
}

