/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.connector;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import gdavid.phi.util.IWarpRedirector;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamAny;

public class BridgeConnector
extends SpellPiece
implements IWarpRedirector {
    public static final ResourceLocation lineTexture = new ResourceLocation("phi", "spell/connector_bridge_lines");
    ParamAny direction;
    @OnlyIn(value=Dist.CLIENT)
    static RenderType lineLayer;

    public BridgeConnector(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.direction = new ParamAny("psi.spellparam.direction", SpellParam.GRAY, true);
        this.addParam((SpellParam)this.direction);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
    }

    public boolean isInputSide(SpellParam.Side side) {
        return false;
    }

    @Override
    public SpellPiece redirect(SpellParam.Side side) {
        if (this.paramSides.get(this.direction) != SpellParam.Side.OFF) {
            side = (SpellParam.Side)this.paramSides.get(this.direction);
        }
        try {
            Class<?> clazz = Class.forName("vazkii.psi.common.spell.other.PieceConnector");
            SpellPiece connector = (SpellPiece)clazz.getConstructor(Spell.class).newInstance(this.spell);
            connector.paramSides.put((SpellParam)clazz.getField("target").get(connector), side);
            connector.x = this.x + side.offx;
            connector.y = this.y + side.offy;
            return connector;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawParams(PoseStack ms, MultiBufferSource buffers, int light) {
        super.drawParams(ms, buffers, light);
        if (((SpellParam.Side)this.paramSides.get(this.direction)).isEnabled()) {
            this.drawLine(ms, buffers, light, (SpellParam.Side)this.paramSides.get(this.direction));
        } else {
            for (SpellParam.Side side : SpellParam.Side.values()) {
                SpellPiece nb;
                if (!side.isEnabled() || (nb = this.spell.grid.getPieceAtSideSafely(this.x, this.y, side.getOpposite())) == null || !nb.isInputSide(side)) continue;
                this.drawLine(ms, buffers, light, side);
                int index = 0;
                int count = 1;
                SpellPiece underBridge = this.spell.grid.getPieceAtSideSafely(this.x, this.y, side);
                if (underBridge != null) {
                    int nbcount = underBridge.getParamArrowCount(side.getOpposite());
                    if (side.asInt() > side.getOpposite().asInt()) {
                        index += nbcount;
                    }
                    count += nbcount;
                }
                float percent = count > 1 ? (float)index / (float)(count - 1) : 0.5f;
                VertexConsumer buffer = buffers.m_6299_(PsiAPI.internalHandler.getProgrammerLayer());
                this.drawParam(ms, buffer, light, side, this.direction.color, SpellParam.ArrowType.IN, percent);
            }
        }
    }

    public int getParamArrowCount(SpellParam.Side side) {
        if (((SpellParam.Side)this.paramSides.get(this.direction)).isEnabled()) {
            return super.getParamArrowCount(side);
        }
        if (!side.isEnabled()) {
            return 0;
        }
        SpellPiece nb = this.spell.grid.getPieceAtSideSafely(this.x, this.y, side.getOpposite());
        return nb != null && nb.isInputSide(side) ? 1 : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawLine(PoseStack ms, MultiBufferSource buffers, int light, SpellParam.Side side) {
        if (!side.isEnabled()) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ZERO.f_84751_, (int)GlStateManager.SourceFactor.ONE.f_84751_);
        Material material = new Material(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, lineTexture);
        if (lineLayer == null) {
            RenderType.CompositeState glState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172814_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, false, false)).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110661_(new RenderStateShard.CullStateShard(false)).m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
                RenderSystem.m_69478_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }, () -> {
                RenderSystem.m_69461_();
                RenderSystem.m_69453_();
            })).m_110691_(false);
            lineLayer = RenderType.m_173215_((String)lineTexture.toString(), (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)64, (boolean)false, (boolean)false, (RenderType.CompositeState)glState);
        }
        VertexConsumer buffer = material.m_119194_(buffers, get -> lineLayer);
        float minU = side == SpellParam.Side.LEFT || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float minV = side == SpellParam.Side.TOP || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float maxU = minU + 0.5f;
        float maxV = minV + 0.5f;
        int r = 255;
        int g = 255;
        int b = 255;
        int a = 255;
        ms.m_85836_();
        Matrix4f mat = ms.m_85850_().m_85861_();
        mat.m_27648_(new Vector3f((float)(side.offx * 18), (float)(side.offy * 18), 0.0f));
        buffer.m_85982_(mat, -8.0f, 24.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(minU, maxV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 24.0f, 24.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(maxU, maxV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 24.0f, -8.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(maxU, minV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, -8.0f, -8.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(minU, minV).m_85969_(light).m_5752_();
        ms.m_85849_();
        RenderSystem.m_69461_();
    }

    public String getSortingName() {
        return "00000000000";
    }

    public EnumPieceType getPieceType() {
        return EnumPieceType.CONNECTOR;
    }

    public Class<?> getEvaluationType() {
        return SpellParam.Any.class;
    }

    public Object evaluate() throws SpellCompilationException {
        return null;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        return null;
    }
}

