/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.connector;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gdavid.phi.util.SpellCachedView;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.IGenericRedirector;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;

public class ClockwiseConnector
extends SpellPiece
implements IGenericRedirector {
    private final SpellCachedView<Set<SpellParam.Side>> isInputSideView = new SpellCachedView<Set>(this, () -> {
        HashSet<SpellParam.Side> res = new HashSet<SpellParam.Side>();
        for (SpellParam.Side side : SpellParam.Side.values()) {
            SpellPiece piece;
            if (!side.isEnabled() || (piece = this.spell.grid.getPieceAtSideSafely(this.x, this.y, this.reverseSide(side).getOpposite())) == null || !piece.isInputSide(this.reverseSide(side))) continue;
            res.add(side);
        }
        return res;
    }, Collections::emptySet);

    public ClockwiseConnector(Spell spell) {
        super(spell);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
    }

    public SpellParam.Side remapSide(SpellParam.Side side) {
        return side.rotateCCW();
    }

    public SpellParam.Side reverseSide(SpellParam.Side side) {
        return side.rotateCW();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawParams(PoseStack ms, MultiBufferSource buffers, int light) {
        VertexConsumer buffer = buffers.m_6299_(PsiAPI.internalHandler.getProgrammerLayer());
        for (SpellParam.Side side : SpellParam.Side.values()) {
            if (!this.isInputSide(side)) continue;
            int index = 0;
            int count = 1;
            SpellPiece neighbour = this.spell.grid.getPieceAtSideSafely(this.x, this.y, side);
            if (neighbour != null) {
                int nbcount = neighbour.getParamArrowCount(side.getOpposite());
                if (side.asInt() > side.getOpposite().asInt()) {
                    index += nbcount;
                }
                count += nbcount;
            }
            float percent = count > 1 ? (float)index / (float)(count - 1) : 0.5f;
            this.drawParam(ms, buffer, light, side, SpellParam.GRAY, SpellParam.ArrowType.IN, percent);
        }
    }

    public int getParamArrowCount(SpellParam.Side side) {
        return this.isInputSide(side) ? 1 : 0;
    }

    public String getSortingName() {
        return "00000000000";
    }

    public EnumPieceType getPieceType() {
        return EnumPieceType.CONNECTOR;
    }

    public Class<?> getEvaluationType() {
        return SpellParam.Any.class;
    }

    public Object evaluate() throws SpellCompilationException {
        return null;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        return null;
    }

    public boolean isInputSide(SpellParam.Side side) {
        return this.isInputSideView.get().contains(side);
    }
}

