/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.constant;

import com.mojang.blaze3d.vertex.PoseStack;
import gdavid.phi.spell.Param;
import gdavid.phi.spell.param.TextParam;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;

public class FormattingCodeConstant
extends SpellPiece {
    public static final String tagValue = "value";
    SpellParam<String> prefix;
    public char code;

    public FormattingCodeConstant(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.prefix = new TextParam(Param.pre.name, SpellParam.GRAY, true, true);
        this.addParam((SpellParam)this.prefix);
        this.code = (char)45;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(PoseStack ms, MultiBufferSource buffers, int light) {
        Font font = Minecraft.m_91087_().f_91062_;
        ms.m_85836_();
        ChatFormatting format = ChatFormatting.m_126645_((char)this.code);
        if (format == null) {
            format = ChatFormatting.RESET;
        }
        FormattedCharSequence rstr = FormattedCharSequence.m_13693_((int)167, (Style)Style.f_131099_.m_131164_(format));
        if (this.code != '-') {
            rstr = FormattedCharSequence.m_13733_((FormattedCharSequence)rstr, (FormattedCharSequence)FormattedCharSequence.m_13693_((int)this.code, (Style)Style.f_131099_));
        }
        ms.m_85837_((double)(8.0f - (float)font.m_92724_(rstr) / 2.0f), 4.0, 0.0);
        font.m_92733_(rstr, 0.0f, 0.0f, 0xFFFFFF, false, ms.m_85850_().m_85861_(), buffers, false, 0, light);
        ms.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean interceptKeystrokes() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onCharTyped(char ch, int key, boolean doit) {
        if (ch != '-' && ChatFormatting.m_126645_((char)ch) == null) {
            return false;
        }
        if (doit) {
            this.code = ch;
        }
        return true;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        return (String)this.getParamValueOrDefault(context, this.prefix, "") + "\u00a7" + String.valueOf(this.code == '-' ? "" : Character.valueOf(this.code));
    }

    public void writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128359_(tagValue, String.valueOf(this.code));
    }

    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        String str = nbt.m_128461_(tagValue);
        if (str.length() != 1) {
            this.code = (char)45;
        } else {
            this.code = str.charAt(0);
            if (ChatFormatting.m_126645_((char)this.code) == null) {
                this.code = (char)45;
            }
        }
    }

    public Class<?> getEvaluationType() {
        return String.class;
    }

    public EnumPieceType getPieceType() {
        return EnumPieceType.CONSTANT;
    }

    public Object evaluate() throws SpellCompilationException {
        return (String)this.getParamEvaluationeOrDefault(this.prefix, "") + "\u00a7" + String.valueOf(this.code == '-' ? "" : Character.valueOf(this.code));
    }
}

