/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.constant;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellPiece;

public class VectorConstant
extends SpellPiece {
    public String[] components;
    public static int selectedComponent = 0;

    public VectorConstant(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.components = new String[]{"0", "0", "0"};
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(PoseStack ms, MultiBufferSource buffers, int light) {
        Font font = Minecraft.m_91087_().f_91062_;
        ms.m_85836_();
        ms.m_85837_(2.0, 2.0, 0.0);
        ms.m_85841_(0.5f, 0.5f, 1.0f);
        for (int i = 0; i < 3; ++i) {
            boolean selected = true;
            try {
                Class<?> clazz = Class.forName("vazkii.psi.client.gui.GuiProgrammer");
                selected = clazz.isInstance(Minecraft.m_91087_().f_91080_) && clazz.getField("selectedX").getInt(null) == this.x && clazz.getField("selectedY").getInt(null) == this.y;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.components[i].length() > 5) {
                this.components[i] = "0";
            }
            int color = selected && selectedComponent == i ? 0xFFFFFF : 0x808080 | 255 << (2 - i) * 8;
            font.m_92811_(this.components[i], 0.0f, 0.0f, color, false, ms.m_85850_().m_85861_(), buffers, false, 0, light);
            ms.m_85837_(0.0, 8.0, 0.0);
        }
        ms.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean interceptKeystrokes() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onCharTyped(char ch, int key, boolean doit) {
        if (ch >= 'x' && ch <= 'z') {
            selectedComponent = ch - 120;
        } else if (ch >= 'X' && ch <= 'Z') {
            selectedComponent = ch - 88;
        } else {
            if ("FDfd".indexOf(ch) != -1) {
                return false;
            }
            Object tmp = this.components[selectedComponent];
            if ((((String)tmp).equals("0") || ((String)tmp).equals("-0")) && ch != '-' && ch != '+') {
                tmp = ((String)tmp).replace("0", "");
            }
            if (ch == '+') {
                if (((String)tmp).startsWith("-")) {
                    tmp = ((String)tmp).substring(1);
                }
            } else if (ch == '-') {
                if (!((String)tmp).startsWith("-")) {
                    tmp = "-" + (String)tmp;
                }
            } else {
                tmp = ((String)tmp + ch).trim();
            }
            if (((String)tmp).length() > 5) {
                if (((String)tmp).startsWith("0.")) {
                    tmp = ((String)tmp).substring(1);
                } else if (((String)tmp).startsWith("-0.")) {
                    tmp = "-" + ((String)tmp).substring(2);
                }
            } else if (((String)tmp).startsWith(".")) {
                tmp = "0" + (String)tmp;
            } else if (((String)tmp).startsWith("-.")) {
                tmp = "-0" + ((String)tmp).substring(1);
            }
            if (((String)tmp).length() > 5) {
                return false;
            }
            if (((String)tmp).isEmpty()) {
                tmp = "0";
            }
            try {
                Double.parseDouble((String)tmp);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (doit) {
                this.components[VectorConstant.selectedComponent] = tmp;
            }
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onKeyPressed(int key, int scanCode, boolean doit) {
        if (this.components[selectedComponent].length() == 0) {
            return false;
        }
        if (key == 259) {
            if (doit) {
                Object tmp = this.components[selectedComponent];
                if (((String)tmp).startsWith(".")) {
                    tmp = "0" + (String)tmp;
                } else if (((String)tmp).startsWith("-.")) {
                    tmp = "-0" + ((String)tmp).substring(1);
                }
                tmp = ((String)tmp).equals("-0") ? "0" : (((String)tmp).startsWith("-") && ((String)tmp).length() == 2 ? "-0" : ((String)tmp).substring(0, ((String)tmp).length() - 1).trim());
                if (((String)tmp).isEmpty()) {
                    tmp = "0";
                }
                try {
                    Double.parseDouble((String)tmp);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (doit) {
                    this.components[VectorConstant.selectedComponent] = tmp;
                }
            }
            return true;
        }
        return false;
    }

    public Object evaluate() {
        for (int i = 0; i < 3; ++i) {
            if (this.components[i].length() <= 5) continue;
            this.components[i] = "0";
        }
        try {
            return new Vector3(Double.parseDouble(this.components[0]), Double.parseDouble(this.components[1]), Double.parseDouble(this.components[2]));
        }
        catch (NumberFormatException e) {
            return Vector3.zero;
        }
    }

    public Object execute(SpellContext context) {
        return this.evaluate();
    }

    public void writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128359_("x", this.components[0]);
        nbt.m_128359_("y", this.components[1]);
        nbt.m_128359_("z", this.components[2]);
    }

    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.components[0] = nbt.m_128461_("x");
        this.components[1] = nbt.m_128461_("y");
        this.components[2] = nbt.m_128461_("z");
    }

    public Class<?> getEvaluationType() {
        return Vector3.class;
    }

    public EnumPieceType getPieceType() {
        return EnumPieceType.CONSTANT;
    }
}

