/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.operator.error;

import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import gdavid.phi.spell.error.PropagatingSpellRuntimeException;
import gdavid.phi.spell.param.ErrorParam;
import gdavid.phi.util.EvalHelper;
import gdavid.phi.util.IModifierFlagProvider;
import gdavid.phi.util.TypeHelper;
import java.util.function.Function;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamAny;
import vazkii.psi.api.spell.piece.PieceOperator;

public class ErrorCatcherOperator
extends PieceOperator
implements IModifierFlagProvider {
    ErrorParam target;
    SpellParam<SpellParam.Any> fallback;

    public ErrorCatcherOperator(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.target = new ErrorParam("psi.spellparam.target", SpellParam.BROWN, false);
        this.addParam((SpellParam)this.target);
        this.fallback = new ParamAny(Param.fallback.name, SpellParam.GRAY, true);
        this.addParam((SpellParam)this.fallback);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        SpellPiece piece = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, (SpellParam.Side)this.paramSides.get((Object)this.target));
        if (piece != null && piece.getEvaluationType() != Void.class && !((SpellParam.Side)this.paramSides.get(this.fallback)).isEnabled()) {
            Errors.compile("psi.spellerror.unsetparam");
        }
    }

    @Override
    public void addFlags(SpellMetadata meta) throws SpellCompilationException {
        SpellPiece piece = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, (SpellParam.Side)this.paramSides.get((Object)this.target));
        if (piece == null) {
            return;
        }
        meta.setFlag(PropagatingSpellRuntimeException.suppressFlag(piece), true);
    }

    public Class<?> getEvaluationType() {
        if (!(this.isInGrid && ((SpellParam.Side)this.paramSides.get((Object)this.target)).isEnabled() && ((SpellParam.Side)this.paramSides.get(this.fallback)).isEnabled())) {
            return SpellParam.Any.class;
        }
        try {
            SpellPiece piece1 = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, (SpellParam.Side)this.paramSides.get((Object)this.target));
            if (piece1 == null || EvalHelper.isLoop(piece1)) {
                return SpellParam.Any.class;
            }
            SpellPiece piece2 = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, (SpellParam.Side)this.paramSides.get(this.fallback));
            if (piece2 == null || EvalHelper.isLoop(piece2)) {
                return Void.class;
            }
            if (piece1.getEvaluationType() == Void.class || piece2.getEvaluationType() == Void.class) {
                return Void.class;
            }
            Class<?> clazz = TypeHelper.commonSuper(piece1.getEvaluationType(), piece2.getEvaluationType());
            return clazz == null ? Object.class : clazz;
        }
        catch (SpellCompilationException e) {
            return SpellParam.Any.class;
        }
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        return this.target.get((SpellPiece)this, context).map(Function.identity(), error -> this.getRawParamValue(context, this.fallback));
    }
}

