/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.operator.number;

import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import java.math.BigDecimal;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceOperator;

public class ExtractDigitOperator
extends PieceOperator {
    SpellParam<Number> number;
    SpellParam<Number> digit;
    SpellParam<Number> base;

    public ExtractDigitOperator(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.number = new ParamNumber("psi.spellparam.number", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.number);
        this.digit = new ParamNumber(Param.digit.name, SpellParam.RED, false, false);
        this.addParam((SpellParam)this.digit);
        this.base = new ParamNumber("psi.spellparam.base", SpellParam.BLUE, true, false);
        this.addParam((SpellParam)this.base);
    }

    public Class<?> getEvaluationType() {
        return Double.class;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        double num = ((Number)this.getParamValue(context, this.number)).doubleValue();
        int d = ((Number)this.getParamValue(context, this.digit)).intValue();
        double b = ((Number)this.getParamValueOrDefault(context, this.base, 10)).doubleValue();
        if (d <= 0) {
            Errors.runtime("psi.spellerror.nonpositivevalue");
        }
        if (b <= 1.0) {
            Errors.runtime("psi.spellerror.invalid_base");
        }
        BigDecimal bd = BigDecimal.valueOf(b);
        return BigDecimal.valueOf(num).divideToIntegralValue(bd.pow(d - 1)).remainder(bd).intValue();
    }
}

