/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.operator.text;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import gdavid.phi.spell.param.ReferenceParam;
import gdavid.phi.spell.param.TextParam;
import gdavid.phi.util.ISidedResult;
import gdavid.phi.util.ParamHelper;
import gdavid.phi.util.RenderHelper;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.piece.PieceOperator;

public class SplitTextAtOperator
extends PieceOperator {
    public static final ResourceLocation lineTexture = new ResourceLocation("phi", "spell/operator_split_text_at_lines");
    public SpellParam<String> text;
    public SpellParam<String> at;
    ReferenceParam before;
    ReferenceParam after;

    public SplitTextAtOperator(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.text = new TextParam(Param.text.name, SpellParam.GRAY, false, false);
        this.addParam((SpellParam)this.text);
        this.at = new TextParam(Param.at.name, SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.at);
        this.before = new ReferenceParam(Param.before.name, SpellParam.RED, true, true, SpellParam.ArrowType.NONE);
        this.addParam((SpellParam)this.before);
        this.after = new ReferenceParam(Param.after.name, SpellParam.GREEN, true, true, SpellParam.ArrowType.NONE);
        this.addParam((SpellParam)this.after);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToTooltipAfterShift(List<Component> tooltip) {
        ParamHelper.outputTooltip((SpellPiece)this, x$0 -> super.addToTooltipAfterShift(x$0), tooltip);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(PoseStack ms, MultiBufferSource buffers, int light) {
        this.drawLine(ms, buffers, light, -1, (SpellParam.Side)this.paramSides.get(this.text));
        this.drawLine(ms, buffers, light, -1, (SpellParam.Side)this.paramSides.get(this.at));
        this.drawLine(ms, buffers, light, this.before.color, (SpellParam.Side)this.paramSides.get((Object)this.before));
        this.drawLine(ms, buffers, light, this.after.color, (SpellParam.Side)this.paramSides.get((Object)this.after));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawLine(PoseStack ms, MultiBufferSource buffers, int light, int color, SpellParam.Side side) {
        if (!side.isEnabled()) {
            return;
        }
        Material material = new Material(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, lineTexture);
        VertexConsumer buffer = material.m_119194_(buffers, get -> SpellPiece.getLayer());
        float minU = side == SpellParam.Side.LEFT || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float minV = side == SpellParam.Side.TOP || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float maxU = minU + 0.5f;
        float maxV = minV + 0.5f;
        int r = RenderHelper.r(color);
        int g = RenderHelper.g(color);
        int b = RenderHelper.b(color);
        int a = 255;
        Matrix4f mat = ms.m_85850_().m_85861_();
        buffer.m_85982_(mat, 0.0f, 16.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(minU, maxV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 16.0f, 16.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(maxU, maxV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 16.0f, 0.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(maxU, minV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(minU, minV).m_85969_(light).m_5752_();
    }

    public Class<?> getEvaluationType() {
        return String.class;
    }

    public boolean isInputSide(SpellParam.Side side) {
        return this.paramSides.get(this.text) == side || this.paramSides.get(this.at) == side;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        String substr;
        String str = (String)this.getParamValue(context, this.text);
        int pos = str.indexOf(substr = (String)this.getParamValue(context, this.at));
        if (pos == -1) {
            Errors.runtime("psi.spellerror.nulltarget");
        }
        return new Result(str.substring(0, pos), str.substring(pos + substr.length()), (SpellParam.Side)this.paramSides.get((Object)this.before), (SpellParam.Side)this.paramSides.get((Object)this.after));
    }

    public static class Result
    implements ISidedResult {
        public final String before;
        public final String after;
        public final SpellParam.Side sbefore;
        public final SpellParam.Side safter;

        public Result(String before, String after, SpellParam.Side sbefore, SpellParam.Side safter) {
            this.before = before;
            this.after = after;
            this.sbefore = sbefore;
            this.safter = safter;
        }

        @Override
        public Object get(SpellParam.Side side) throws SpellRuntimeException {
            if (side == this.sbefore) {
                return this.before;
            }
            if (side == this.safter) {
                return this.after;
            }
            Errors.runtime("psi.spellerror.invalidparam");
            return null;
        }
    }
}

