/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.operator.vector;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import gdavid.phi.spell.Errors;
import gdavid.phi.spell.param.ReferenceParam;
import gdavid.phi.util.ISidedResult;
import gdavid.phi.util.ParamHelper;
import gdavid.phi.util.RenderHelper;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;

public class SplitVectorOperator
extends SpellPiece {
    public static final ResourceLocation lineTexture = new ResourceLocation("phi", "spell/operator_split_vector_lines");
    public SpellParam<Vector3> vector;
    ReferenceParam outX;
    ReferenceParam outY;
    ReferenceParam outZ;

    public SplitVectorOperator(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.vector = new ParamVector("psi.spellparam.vector", SpellParam.GRAY, false, false);
        this.addParam((SpellParam)this.vector);
        this.outX = new ReferenceParam("psi.spellparam.x", SpellParam.RED, true, true, SpellParam.ArrowType.NONE);
        this.addParam((SpellParam)this.outX);
        this.outY = new ReferenceParam("psi.spellparam.y", SpellParam.GREEN, true, true, SpellParam.ArrowType.NONE);
        this.addParam((SpellParam)this.outY);
        this.outZ = new ReferenceParam("psi.spellparam.z", SpellParam.BLUE, true, true, SpellParam.ArrowType.NONE);
        this.addParam((SpellParam)this.outZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToTooltipAfterShift(List<Component> tooltip) {
        ParamHelper.outputTooltip(this, x$0 -> super.addToTooltipAfterShift(x$0), tooltip);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        int components = 0;
        if (((SpellParam.Side)this.paramSides.get((Object)this.outX)).isEnabled()) {
            ++components;
        }
        if (((SpellParam.Side)this.paramSides.get((Object)this.outY)).isEnabled()) {
            ++components;
        }
        if (((SpellParam.Side)this.paramSides.get((Object)this.outZ)).isEnabled()) {
            ++components;
        }
        meta.addStat(EnumSpellStat.COMPLEXITY, components);
        if (components > 1) {
            meta.addStat(EnumSpellStat.COMPLEXITY, 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(PoseStack ms, MultiBufferSource buffers, int light) {
        this.drawLine(ms, buffers, light, -1, (SpellParam.Side)this.paramSides.get(this.vector));
        this.drawLine(ms, buffers, light, this.outX.color, (SpellParam.Side)this.paramSides.get((Object)this.outX));
        this.drawLine(ms, buffers, light, this.outY.color, (SpellParam.Side)this.paramSides.get((Object)this.outY));
        this.drawLine(ms, buffers, light, this.outZ.color, (SpellParam.Side)this.paramSides.get((Object)this.outZ));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawLine(PoseStack ms, MultiBufferSource buffers, int light, int color, SpellParam.Side side) {
        if (!side.isEnabled()) {
            return;
        }
        Material material = new Material(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, lineTexture);
        VertexConsumer buffer = material.m_119194_(buffers, get -> SpellPiece.getLayer());
        float minU = side == SpellParam.Side.LEFT || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float minV = side == SpellParam.Side.TOP || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float maxU = minU + 0.5f;
        float maxV = minV + 0.5f;
        int r = RenderHelper.r(color);
        int g = RenderHelper.g(color);
        int b = RenderHelper.b(color);
        int a = 255;
        Matrix4f mat = ms.m_85850_().m_85861_();
        buffer.m_85982_(mat, 0.0f, 16.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(minU, maxV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 16.0f, 16.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(maxU, maxV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 16.0f, 0.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(maxU, minV).m_85969_(light).m_5752_();
        buffer.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a);
        buffer.m_7421_(minU, minV).m_85969_(light).m_5752_();
    }

    public EnumPieceType getPieceType() {
        return EnumPieceType.OPERATOR;
    }

    public Class<?> getEvaluationType() {
        return Double.class;
    }

    public Object evaluate() throws SpellCompilationException {
        return null;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        return new Result((Vector3)this.getNonnullParamValue(context, this.vector), (SpellParam.Side)this.paramSides.get((Object)this.outX), (SpellParam.Side)this.paramSides.get((Object)this.outY), (SpellParam.Side)this.paramSides.get((Object)this.outZ));
    }

    public boolean isInputSide(SpellParam.Side side) {
        return this.paramSides.get(this.vector) == side;
    }

    public static class Result
    implements ISidedResult {
        public final Vector3 value;
        public final SpellParam.Side x;
        public final SpellParam.Side y;
        public final SpellParam.Side z;

        public Result(Vector3 value, SpellParam.Side x, SpellParam.Side y, SpellParam.Side z) {
            this.value = value;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public Object get(SpellParam.Side side) throws SpellRuntimeException {
            if (side == this.x) {
                return this.value.x;
            }
            if (side == this.y) {
                return this.value.y;
            }
            if (side == this.z) {
                return this.value.z;
            }
            Errors.runtime("psi.spellerror.invalidparam");
            return null;
        }
    }
}

