/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.operator.vector.raycast;

import gdavid.phi.spell.Errors;
import gdavid.phi.util.ParamHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;

public class OffsetRaycastOperator
extends PieceOperator {
    SpellParam<Vector3> origin;
    SpellParam<Vector3> ray;
    SpellParam<Number> max;

    public OffsetRaycastOperator(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.origin = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.origin);
        this.ray = new ParamVector("psi.spellparam.ray", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.ray);
        this.max = new ParamNumber("psi.spellparam.max", SpellParam.PURPLE, true, false);
        this.addParam((SpellParam)this.max);
    }

    public Class<?> getEvaluationType() {
        return Vector3.class;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 start = (Vector3)this.getNonnullParamValue(context, this.origin);
        Vector3 direction = ParamHelper.nonNull((SpellPiece)this, context, this.ray);
        double length = ((Number)this.getParamValueOrDefault(context, this.max, 32.0)).doubleValue();
        length = Math.max(Math.min(length, 32.0), -32.0);
        Vector3 end = start.copy().add(direction.copy().normalize().multiply(length));
        BlockHitResult res = context.focalPoint.f_19853_.m_45547_(new ClipContext(start.toVec3D(), end.toVec3D(), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, context.focalPoint));
        if (res.m_6662_() == HitResult.Type.MISS) {
            Errors.runtime("psi.spellerror.nullvector");
        }
        return Vector3.fromVec3d((Vec3)res.m_82450_()).subtract(Vector3.fromBlockPos((BlockPos)res.m_82425_())).subtract(new Vector3(0.5, 0.5, 0.5));
    }
}

