/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.selector;

import gdavid.phi.spell.Errors;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceSelector;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;

public class NearbyBurningSelector
extends PieceSelector {
    SpellParam<Vector3> position;
    SpellParam<Number> radius;

    public NearbyBurningSelector(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, true, false);
        this.addParam((SpellParam)this.position);
        this.radius = new ParamNumber("psi.spellparam.radius", SpellParam.GREEN, true, false);
        this.addParam((SpellParam)this.radius);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValueOrDefault(context, this.position, Vector3.fromVec3d((Vec3)context.focalPoint.m_20182_()));
        double radiusVal = ((Number)this.getParamValueOrDefault(context, this.radius, 32.0)).doubleValue();
        if (radiusVal <= 0.0) {
            Errors.runtime("psi.spellerror.nonpositivevalue");
        }
        if (MathHelper.pointDistanceSpace((double)positionVal.x, (double)positionVal.y, (double)positionVal.z, (double)context.focalPoint.m_20185_(), (double)context.focalPoint.m_20186_(), (double)context.focalPoint.m_20189_()) > 32.0) {
            Errors.runtime("psi.spellerror.outsideradius");
        }
        AABB boundingBox = AABB.m_165882_((Vec3)positionVal.toVec3D(), (double)radiusVal, (double)radiusVal, (double)radiusVal);
        boundingBox = boundingBox.m_82323_(AABB.m_165882_((Vec3)context.focalPoint.m_20182_(), (double)32.0, (double)32.0, (double)32.0));
        return EntityListWrapper.make((List)context.focalPoint.m_20193_().m_6443_(Entity.class, boundingBox, Entity::m_6060_));
    }

    public Class<?> getEvaluationType() {
        return EntityListWrapper.class;
    }
}

