/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.selector.mpu;

import gdavid.phi.block.tile.MPUTile;
import gdavid.phi.block.tile.VSUTile;
import gdavid.phi.spell.Errors;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceSelector;

public class ReadVectorStorageSelector
extends PieceSelector {
    SpellParam<Vector3> direction;

    public ReadVectorStorageSelector(Spell spell) {
        super(spell);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 10);
    }

    public void initParams() {
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.direction);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToTooltipAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"phi.tooltip.require_mpu"));
        super.addToTooltipAfterShift(tooltip);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        BlockEntity tile;
        BlockPos pos;
        Vector3 dir = (Vector3)this.getNonnullParamValue(context, this.direction);
        Direction d = Direction.m_122366_((double)dir.x, (double)dir.y, (double)dir.z);
        if (!(context.caster instanceof MPUTile.MPUCaster)) {
            Errors.noMpu.runtime();
        }
        if ((pos = ((MPUTile.MPUCaster)context.caster).getConnected(d)) == null) {
            Errors.runtime("psi.spellerror.nulltarget");
        }
        if (!((tile = context.caster.f_19853_.m_7702_(pos)) instanceof VSUTile)) {
            Errors.runtime("psi.spellerror.nulltarget");
        }
        return ((VSUTile)tile).getVector();
    }

    public Class<?> getEvaluationType() {
        return Vector3.class;
    }
}

