/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick;

import gdavid.phi.spell.Errors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PlaceDroppedBlockTrick
extends PieceTrick {
    SpellParam<Entity> target;

    public PlaceDroppedBlockTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam((SpellParam)this.target);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 6);
        meta.addStat(EnumSpellStat.COST, 6);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        BlockHitResult hit;
        BlockPlaceContext ctx;
        BlockPos pos;
        Entity targetVal = (Entity)this.getNonnullParamValue(context, this.target);
        if (!(targetVal instanceof ItemEntity)) {
            Errors.invalidTarget.runtime();
        }
        if (!context.focalPoint.f_19853_.m_46805_(pos = targetVal.m_20183_()) || !context.focalPoint.f_19853_.m_7966_(context.caster, pos)) {
            return null;
        }
        BlockState state = context.focalPoint.f_19853_.m_8055_(pos);
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)context.focalPoint.f_19853_.m_46472_(), (LevelAccessor)context.focalPoint.f_19853_, (BlockPos)pos), context.focalPoint.f_19853_.m_8055_(pos.m_7494_()), (Entity)context.caster);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!state.m_60795_() && !state.m_60767_().m_76336_() || event.isCanceled()) {
            return null;
        }
        ItemEntity item = (ItemEntity)targetVal;
        ItemStack stack = item.m_32055_().m_41777_();
        if (!(stack.m_41720_() instanceof BlockItem)) {
            return null;
        }
        ItemStack placed = stack.m_41620_(1);
        BlockItem blockItem = (BlockItem)placed.m_41720_();
        InteractionResult result = blockItem.m_40576_(ctx = new BlockPlaceContext(context.focalPoint.f_19853_, context.caster, InteractionHand.MAIN_HAND, placed, hit = new BlockHitResult(Vec3.f_82478_, Direction.UP, pos, false)));
        if (result == InteractionResult.FAIL) {
            return null;
        }
        if (stack.m_41619_()) {
            item.m_146870_();
        } else {
            item.m_32045_(stack);
        }
        context.focalPoint.f_19853_.m_46796_(2001, pos, Block.m_49956_((BlockState)context.focalPoint.f_19853_.m_8055_(pos)));
        return null;
    }
}

