/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick;

import com.mojang.math.Vector3f;
import gdavid.phi.block.tile.MPUTile;
import gdavid.phi.entity.PsionWaveEntity;
import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import gdavid.phi.util.ParamHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PsionWaveTrick
extends PieceTrick {
    SpellParam<Vector3> direction;
    SpellParam<Number> speed;
    SpellParam<Number> frequency;
    SpellParam<Number> distance;

    public PsionWaveTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.direction);
        this.speed = new ParamNumber(Param.speed.name, SpellParam.RED, false, true);
        this.addParam((SpellParam)this.speed);
        this.frequency = new ParamNumber(Param.frequency.name, SpellParam.BLUE, false, true);
        this.addParam((SpellParam)this.frequency);
        this.distance = new ParamNumber("psi.spellparam.distance", SpellParam.CYAN, false, true);
        this.addParam((SpellParam)this.distance);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        double distanceVal;
        double frequencyVal;
        super.addToMetadata(meta);
        double speedVal = ParamHelper.positive((SpellPiece)this, this.speed);
        if (speedVal < 1.0) {
            Errors.minWave.compile();
        }
        if ((frequencyVal = ParamHelper.positive((SpellPiece)this, this.frequency)) < 1.0) {
            Errors.minWave.compile();
        }
        if ((distanceVal = ParamHelper.positive((SpellPiece)this, this.distance)) < 1.0) {
            Errors.minWave.compile();
        }
        if (distanceVal > 32.0) {
            Errors.range.compile();
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(speedVal * Math.pow(frequencyVal, 1.2) * distanceVal));
        meta.addStat(EnumSpellStat.COST, (int)(speedVal * Math.pow(frequencyVal, 1.2) * distanceVal));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 directionVal = ParamHelper.nonNull((SpellPiece)this, context, this.direction).copy().normalize();
        float speedVal = ((Number)this.getNonnullParamValue(context, this.speed)).floatValue();
        float frequencyVal = ((Number)this.getNonnullParamValue(context, this.frequency)).floatValue();
        float distanceVal = ((Number)this.getNonnullParamValue(context, this.distance)).floatValue();
        if (speedVal < 1.0f || frequencyVal < 1.0f || distanceVal < 1.0f) {
            return null;
        }
        distanceVal = Math.max(1.0f, distanceVal);
        if (context.focalPoint.m_20193_() instanceof ServerLevel) {
            PsionWaveEntity wave = new PsionWaveEntity(context.focalPoint.m_20193_(), new Vector3f((float)directionVal.x, (float)directionVal.y, (float)directionVal.z), speedVal, frequencyVal, distanceVal);
            ItemStack cad = PsiAPI.getPlayerCAD((Player)context.caster);
            if (!cad.m_41619_()) {
                wave.setColorizer(((ICAD)cad.m_41720_()).getComponentInSlot(cad, EnumCADComponent.DYE));
            }
            wave.m_6034_(context.focalPoint.m_20185_(), context.focalPoint.m_20186_() + (double)context.focalPoint.m_20192_() - (context.focalPoint instanceof MPUTile.MPUCaster ? 0.0 : 0.5), context.focalPoint.m_20189_());
            wave.m_5602_(context.focalPoint);
            wave.m_20193_().m_7967_((Entity)wave);
        }
        context.delay = 5;
        return null;
    }
}

