/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick;

import gdavid.phi.block.ModBlocks;
import gdavid.phi.spell.Errors;
import gdavid.phi.util.ParamHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class ShadowSequenceTrick
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Number> time;
    SpellParam<Vector3> target;
    SpellParam<Number> maxBlocks;

    public ShadowSequenceTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.position);
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.PURPLE, false, false);
        this.addParam((SpellParam)this.time);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", SpellParam.RED, false, false);
        this.addParam((SpellParam)this.maxBlocks);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        int timeVal = (int)ParamHelper.positive((SpellPiece)this, this.time);
        int max = (int)ParamHelper.positive((SpellPiece)this, this.maxBlocks);
        meta.addStat(EnumSpellStat.POTENCY, timeVal / 2 * max);
        meta.addStat(EnumSpellStat.COST, 40 + 20 * (max - 1));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 pos = ParamHelper.nonNull((SpellPiece)this, context, this.position);
        int timeVal = ((Number)this.getNonnullParamValue(context, this.time)).intValue();
        int max = ((Number)this.getNonnullParamValue(context, this.maxBlocks)).intValue();
        Vector3 to = ParamHelper.nonNull((SpellPiece)this, context, this.target).copy().normalize().multiply((double)max);
        Level world = context.focalPoint.m_20193_();
        for (BlockPos at : MathHelper.getBlocksAlongRay((Vec3)pos.toVec3D(), (Vec3)pos.copy().add(to).toVec3D(), (int)max)) {
            BlockState block;
            if (!context.isInRadius(Vector3.fromBlockPos((BlockPos)at))) {
                Errors.runtime("psi.spellerror.outsideradius");
            }
            if (!world.m_46805_(at) || !world.m_7966_(context.caster, at) || !(block = world.m_8055_(at)).m_60795_() && !block.m_60767_().m_76336_() || !world.m_46597_(at, ModBlocks.shadow.m_49966_())) continue;
            world.m_186460_(at, ModBlocks.shadow, timeVal);
        }
        return null;
    }
}

