/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick;

import gdavid.phi.block.ModBlocks;
import gdavid.phi.util.ParamHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class ShadowTrick
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Number> time;

    public ShadowTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.position);
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.PURPLE, false, false);
        this.addParam((SpellParam)this.time);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        int timeVal = (int)ParamHelper.positive((SpellPiece)this, this.time);
        meta.addStat(EnumSpellStat.POTENCY, timeVal / 2);
        meta.addStat(EnumSpellStat.COST, 40);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        BlockPos pos = ParamHelper.block((SpellPiece)this, context, this.position);
        int timeVal = ((Number)this.getNonnullParamValue(context, this.time)).intValue();
        Level world = context.focalPoint.m_20193_();
        if (!world.m_46805_(pos) || !world.m_7966_(context.caster, pos)) {
            return null;
        }
        BlockState block = world.m_8055_(pos);
        if ((block.m_60795_() || block.m_60767_().m_76336_()) && world.m_46597_(pos, ModBlocks.shadow.m_49966_())) {
            world.m_186460_(pos, ModBlocks.shadow, timeVal);
        }
        return null;
    }
}

