/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick;

import gdavid.phi.spell.Errors;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class SpinItemChamberTrick
extends PieceTrick {
    SpellParam<Number> slot;
    SpellParam<Number> direction;
    SpellParam<Number> position;

    public SpinItemChamberTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.slot = new ParamNumber("psi.spellparam.slot", SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.slot);
        this.direction = new ParamNumber("psi.spellparam.direction", SpellParam.GREEN, true, false);
        this.addParam((SpellParam)this.direction);
        this.position = new ParamNumber("psi.spellparam.position", SpellParam.RED, true, false);
        this.addParam((SpellParam)this.position);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 10);
        if (!((SpellParam.Side)this.paramSides.get(this.direction)).isEnabled() && !((SpellParam.Side)this.paramSides.get(this.position)).isEnabled()) {
            Errors.compile("psi.spellerror.unsetparam");
        } else if (((SpellParam.Side)this.paramSides.get(this.direction)).isEnabled() && ((SpellParam.Side)this.paramSides.get(this.position)).isEnabled()) {
            Errors.compile("psi.spellerror.exclusiveparams");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(SpellContext context) throws SpellRuntimeException {
        int slotVal = ((Number)this.getNonnullParamValue(context, this.slot)).intValue();
        ItemStack stack = this.getItemInSlot(context, slotVal);
        if (!ISocketable.isSocketable((ItemStack)stack)) {
            Errors.invalidTarget.runtime();
        }
        ISocketable socketable = ISocketable.socketable((ItemStack)stack);
        Number directionVal = (Number)this.getParamValue(context, this.direction);
        int toSelect = socketable.getSelectedSlot();
        if (directionVal != null) {
            if (directionVal.doubleValue() > 0.0) {
                ++toSelect;
            } else {
                if (!(directionVal.doubleValue() < 0.0)) return null;
                --toSelect;
            }
        } else {
            toSelect = ((Number)this.getNonnullParamValue(context, this.position)).intValue() - 1;
        }
        int slots = socketable.getLastSlot() + 1;
        if ((toSelect %= slots) < 0) {
            toSelect += slots;
        }
        socketable.setSelectedSlot(toSelect);
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)context.caster);
        if (!(stack.m_41720_() instanceof ICAD) || context.castFrom != data.loopcastHand || !this.isSlot(context, slotVal, context.castFrom)) return null;
        data.lastTickLoopcastStack = stack.m_41777_();
        return null;
    }

    private ItemStack getItemInSlot(SpellContext context, int slot) throws SpellRuntimeException {
        if (slot > 0) {
            return context.caster.m_150109_().m_8020_(slot % 36);
        }
        if (-slot < EquipmentSlot.values().length) {
            return context.caster.m_6844_(EquipmentSlot.values()[-slot]);
        }
        Errors.invalidTarget.runtime();
        return ItemStack.f_41583_;
    }

    private boolean isSlot(SpellContext context, int slot, InteractionHand hand) {
        return -slot == EquipmentSlot.MAINHAND.m_20749_() && hand == InteractionHand.MAIN_HAND || -slot == EquipmentSlot.OFFHAND.m_20749_() && hand == InteractionHand.OFF_HAND || slot > 0 && slot % 36 == context.caster.m_150109_().f_35977_ - 1;
    }
}

