/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.acceleration;

import gdavid.phi.capability.ModCapabilities;
import gdavid.phi.network.AccelerationMessage;
import gdavid.phi.network.Messages;
import gdavid.phi.spell.Errors;
import gdavid.phi.util.ParamHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class AccelerationTrick
extends PieceTrick {
    SpellParam<Entity> target;
    SpellParam<Vector3> direction;
    SpellParam<Number> power;
    SpellParam<Number> time;

    public AccelerationTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam((SpellParam)this.target);
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.direction);
        this.power = new ParamNumber("psi.spellparam.power", SpellParam.RED, false, true);
        this.addParam((SpellParam)this.power);
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.PURPLE, false, true);
        this.addParam((SpellParam)this.time);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double powerVal = ParamHelper.positiveOrZero((SpellPiece)this, this.power);
        Double timeVal = ((Number)this.getNonNullParamEvaluation(this.time)).doubleValue();
        if (timeVal <= 0.0 || timeVal.doubleValue() != timeVal.doubleValue()) {
            Errors.compile("psi.spellerror.nonpositiveinteger");
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(timeVal * powerVal * 5.0 + powerVal * 50.0));
        meta.addStat(EnumSpellStat.COST, (int)(timeVal * powerVal * 75.0 + powerVal * 100.0));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = (Entity)this.getNonnullParamValue(context, this.target);
        context.verifyEntity(targetVal);
        if (!context.isInRadius(targetVal)) {
            Errors.runtime("psi.spellerror.outsideradius");
        }
        int timeVal = ((Number)this.getNonnullParamValue(context, this.time)).intValue();
        double powerVal = ((Number)this.getNonnullParamValue(context, this.power)).doubleValue() * 0.3;
        Vector3 accel = ParamHelper.nonNull((SpellPiece)this, context, this.direction).copy().normalize().multiply(powerVal);
        targetVal.getCapability(ModCapabilities.acceleration).ifPresent(cap -> cap.addAcceleration(accel, timeVal));
        if (targetVal instanceof Player) {
            Messages.send(new AccelerationMessage(accel, timeVal), (Player)targetVal);
        }
        return null;
    }
}

