/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.blink;

import gdavid.phi.spell.Errors;
import java.util.EnumSet;
import java.util.Stack;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class BlinkEidosReversalTrick
extends PieceTrick {
    SpellParam<Number> time;

    public BlinkEidosReversalTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.PURPLE, false, true);
        this.addParam((SpellParam)this.time);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double timeVal = ((Number)this.getNonNullParamEvaluation(this.time)).doubleValue();
        if (timeVal <= 0.0 || timeVal != (double)timeVal.intValue()) {
            Errors.compile("psi.spellerror.nonpositiveinteger");
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(timeVal * 20.0 + 30.0));
        meta.addStat(EnumSpellStat.COST, (int)(timeVal * 40.0));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        int timeVal = ((Number)this.getNonnullParamValue(context, this.time)).intValue() * 20;
        if (timeVal == 0) {
            return null;
        }
        Stack eidosLog = PlayerDataHandler.get((Player)context.caster).eidosChangelog;
        if (eidosLog.size() == 0) {
            return null;
        }
        eidosLog.subList(Math.max(eidosLog.size() - timeVal + 1, 1), eidosLog.size()).clear();
        Vector3 pos = (Vector3)eidosLog.pop();
        context.caster.m_6034_(pos.x, pos.y, pos.z);
        if (context.caster instanceof ServerPlayer) {
            ServerGamePacketListenerImpl c = ((ServerPlayer)context.caster).f_8906_;
            c.m_9780_(pos.x, pos.y, pos.z, context.caster.m_146908_(), context.caster.m_146909_(), EnumSet.of(ClientboundPlayerPositionPacket.RelativeArgument.X_ROT, ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT));
            c.m_9953_();
        }
        return null;
    }
}

