/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.blink;

import gdavid.phi.util.ParamHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class CasterBlinkTrick
extends PieceTrick {
    SpellParam<Vector3> direction;
    SpellParam<Number> distance;

    public CasterBlinkTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.direction);
        this.distance = new ParamNumber("psi.spellparam.distance", SpellParam.RED, false, true);
        this.addParam((SpellParam)this.distance);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double maxDistance = ParamHelper.positive((SpellPiece)this, this.distance);
        meta.addStat(EnumSpellStat.POTENCY, (int)(maxDistance * 30.0));
        meta.addStat(EnumSpellStat.COST, (int)(maxDistance * 40.0));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        double distanceVal = ((Number)this.getNonnullParamValue(context, this.distance)).doubleValue();
        Vector3 directionVal = ParamHelper.nonNull((SpellPiece)this, context, this.direction).copy().normalize().multiply(distanceVal);
        context.caster.m_6034_(context.caster.m_20185_() + directionVal.x, context.caster.m_20186_() + directionVal.y, context.caster.m_20189_() + directionVal.z);
        if (context.caster instanceof ServerPlayer) {
            try {
                Object message = Class.forName("vazkii.psi.common.network.message.MessageBlink").getConstructor(Double.TYPE, Double.TYPE, Double.TYPE).newInstance(directionVal.x, directionVal.y, directionVal.z);
                Class.forName("vazkii.psi.common.network.MessageRegister").getMethod("sendToPlayer", Object.class, Player.class).invoke(null, message, context.caster);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

