/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.blink;

import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import gdavid.phi.util.ParamHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;

public class SwapBlinkTrick
extends PieceTrick {
    SpellParam<Entity> a;
    SpellParam<Entity> b;
    SpellParam<Number> distance;

    public SwapBlinkTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.a = new ParamEntity(Param.target1.name, SpellParam.YELLOW, false, false);
        this.addParam((SpellParam)this.a);
        this.b = new ParamEntity(Param.target2.name, SpellParam.YELLOW, true, false);
        this.addParam((SpellParam)this.b);
        this.distance = new ParamNumber("psi.spellparam.distance", SpellParam.RED, false, true);
        this.addParam((SpellParam)this.distance);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double maxDistance = ParamHelper.positive((SpellPiece)this, this.distance);
        meta.addStat(EnumSpellStat.POTENCY, (int)(Math.sqrt(2.0 * maxDistance) * 40.0));
        meta.addStat(EnumSpellStat.COST, (int)(maxDistance * 40.0));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        ServerGamePacketListenerImpl c;
        Vec3 offset;
        double distanceVal = ((Number)this.getNonnullParamValue(context, this.distance)).doubleValue();
        Entity e1 = (Entity)this.getNonnullParamValue(context, this.a);
        Entity e2 = (Entity)this.getParamValueOrDefault(context, this.b, context.caster);
        context.verifyEntity(e1);
        context.verifyEntity(e2);
        if (!context.isInRadius(e1) || !context.isInRadius(e2)) {
            Errors.runtime("psi.spellerror.outsideradius");
        }
        if ((offset = e2.m_20182_().m_82546_(e1.m_20182_())).m_82556_() > distanceVal * distanceVal) {
            return null;
        }
        Vec3 pos1 = e1.m_20182_();
        Vec2 rot1 = e1.m_20155_();
        float rotyh1 = e1.m_6080_();
        e1.m_19890_(e2.m_20185_(), e2.m_20186_(), e2.m_20189_(), e2.m_146908_(), e2.m_146909_());
        e1.m_5616_(e2.m_6080_());
        if (e1 instanceof ServerPlayer) {
            c = ((ServerPlayer)e1).f_8906_;
            c.m_9774_(e2.m_20185_(), e2.m_20186_(), e2.m_20189_(), e2.m_146908_(), e2.m_146909_());
            c.m_9953_();
        }
        e2.m_19890_(pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, rot1.f_82471_, rot1.f_82470_);
        e2.m_5616_(rotyh1);
        if (e2 instanceof ServerPlayer) {
            c = ((ServerPlayer)e2).f_8906_;
            c.m_9774_(pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, rot1.f_82471_, rot1.f_82470_);
            c.m_9953_();
        }
        return null;
    }
}

