/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.mpu;

import gdavid.phi.block.tile.MPUTile;
import gdavid.phi.entity.PsiProjectileEntity;
import gdavid.phi.util.ParamHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PsiTransferTrick
extends PieceTrick {
    public static final String flag = "phi:psi_transfer";
    SpellParam<Vector3> direction;
    SpellParam<Number> psi;

    public PsiTransferTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.direction);
        this.psi = new ParamNumber("psi.spellparam.power", SpellParam.BLUE, false, true);
        this.addParam((SpellParam)this.psi);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double psiVal = ParamHelper.positive((SpellPiece)this, this.psi);
        meta.addStat(EnumSpellStat.POTENCY, (int)psiVal);
        meta.addStat(EnumSpellStat.COST, (int)Math.ceil(psiVal / 0.98));
        meta.setFlag(flag, true);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 directionVal = ParamHelper.nonNull((SpellPiece)this, context, this.direction).copy().normalize();
        int psiVal = ((Number)this.getNonnullParamValue(context, this.psi)).intValue();
        if (psiVal == 0) {
            return null;
        }
        if (context.focalPoint.m_20193_() instanceof ServerLevel) {
            PsiProjectileEntity projectile = new PsiProjectileEntity(context.focalPoint.m_20193_(), directionVal.toVec3D(), psiVal);
            ItemStack cad = PsiAPI.getPlayerCAD((Player)context.caster);
            if (!cad.m_41619_()) {
                projectile.setColorizer(((ICAD)cad.m_41720_()).getComponentInSlot(cad, EnumCADComponent.DYE));
            }
            projectile.m_6034_(context.focalPoint.m_20185_(), context.focalPoint.m_20186_() + (double)context.focalPoint.m_20192_() - (context.focalPoint instanceof MPUTile.MPUCaster ? 0.0 : 0.5), context.focalPoint.m_20189_());
            projectile.setOrigin();
            projectile.m_20193_().m_7967_((Entity)projectile);
        }
        return null;
    }
}

