/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.mpu;

import gdavid.phi.block.tile.MPUTile;
import gdavid.phi.spell.Errors;
import gdavid.phi.util.ParamHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class SetTimeTrick
extends PieceTrick {
    SpellParam<Number> num;
    SpellParam<Vector3> target;

    public SetTimeTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.num = new ParamNumber("psi.spellparam.time", SpellParam.RED, false, false);
        this.addParam((SpellParam)this.num);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.BLUE, true, false);
        this.addParam((SpellParam)this.target);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToTooltipAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"phi.tooltip.require_mpu"));
        super.addToTooltipAfterShift(tooltip);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
        meta.addStat(EnumSpellStat.POTENCY, 4);
        if (((SpellParam.Side)this.paramSides.get(this.target)).isEnabled()) {
            meta.addStat(EnumSpellStat.POTENCY, 6);
        }
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        int time = ((Number)this.getNonnullParamValue(context, this.num)).intValue();
        if (((SpellParam.Side)this.paramSides.get(this.target)).isEnabled()) {
            BlockPos pos = ParamHelper.block((SpellPiece)this, context, this.target);
            Level world = context.focalPoint.m_20193_();
            if (!world.m_46805_(pos) || !world.m_7966_(context.caster, pos)) {
                return null;
            }
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof MPUTile) {
                ((MPUTile)tile).setTime(time);
            }
        } else {
            if (!(context.caster instanceof MPUTile.MPUCaster)) {
                Errors.noMpu.runtime();
            }
            ((MPUTile.MPUCaster)context.caster).setTime(time);
        }
        return null;
    }
}

