/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.mpu;

import gdavid.phi.block.tile.MPUTile;
import gdavid.phi.block.tile.TextDisplayTile;
import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import gdavid.phi.spell.param.TextParam;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class WriteTextDisplayTrick
extends PieceTrick {
    SpellParam<Vector3> direction;
    SpellParam<String> text;
    SpellParam<Number> line;

    public WriteTextDisplayTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.direction);
        this.text = new TextParam(Param.text.name, SpellParam.RED, false, false);
        this.addParam((SpellParam)this.text);
        this.line = new ParamNumber(Param.line.name, SpellParam.BLUE, true, false);
        this.addParam((SpellParam)this.line);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToTooltipAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"phi.tooltip.require_mpu"));
        super.addToTooltipAfterShift(tooltip);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
        meta.addStat(EnumSpellStat.POTENCY, 5);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        BlockEntity tile;
        BlockPos pos;
        Vector3 dir = (Vector3)this.getNonnullParamValue(context, this.direction);
        Direction d = Direction.m_122366_((double)dir.x, (double)dir.y, (double)dir.z);
        String str = (String)this.getNonnullParamValue(context, this.text);
        if (!(context.caster instanceof MPUTile.MPUCaster)) {
            Errors.noMpu.runtime();
        }
        if ((pos = ((MPUTile.MPUCaster)context.caster).getConnected(d)) == null) {
            Errors.runtime("psi.spellerror.nulltarget");
        }
        if (!((tile = context.caster.f_19853_.m_7702_(pos)) instanceof TextDisplayTile)) {
            Errors.runtime("psi.spellerror.nulltarget");
        }
        if (((SpellParam.Side)this.paramSides.get(this.line)).isEnabled()) {
            ((TextDisplayTile)tile).setLine(str, ((Number)this.getNonnullParamValue(context, this.line)).intValue());
        } else {
            ((TextDisplayTile)tile).appendLine(str);
        }
        return null;
    }
}

