/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.mpu;

import gdavid.phi.block.tile.MPUTile;
import gdavid.phi.block.tile.VSUTile;
import gdavid.phi.spell.Errors;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class WriteVectorStorageTrick
extends PieceTrick {
    SpellParam<Vector3> direction;
    SpellParam<Vector3> vector;

    public WriteVectorStorageTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.direction);
        this.vector = new ParamVector("psi.spellparam.vector", SpellParam.RED, false, false);
        this.addParam((SpellParam)this.vector);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToTooltipAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"phi.tooltip.require_mpu"));
        super.addToTooltipAfterShift(tooltip);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
        meta.addStat(EnumSpellStat.POTENCY, 20);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        BlockEntity tile;
        BlockPos pos;
        Vector3 dir = (Vector3)this.getNonnullParamValue(context, this.direction);
        Direction d = Direction.m_122366_((double)dir.x, (double)dir.y, (double)dir.z);
        Vector3 vec = (Vector3)this.getNonnullParamValue(context, this.vector);
        if (!(context.caster instanceof MPUTile.MPUCaster)) {
            Errors.noMpu.runtime();
        }
        if ((pos = ((MPUTile.MPUCaster)context.caster).getConnected(d)) == null) {
            Errors.runtime("psi.spellerror.nulltarget");
        }
        if (!((tile = context.caster.f_19853_.m_7702_(pos)) instanceof VSUTile)) {
            Errors.runtime("psi.spellerror.nulltarget");
        }
        ((VSUTile)tile).setVector(vec);
        return null;
    }
}

