/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.spirit;

import gdavid.phi.entity.SpiritEntity;
import gdavid.phi.spell.Errors;
import net.minecraft.world.entity.Entity;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.piece.PieceTrick;

public class FocusSpiritTrick
extends PieceTrick {
    public static final String originalFocus = "phi:original_focus";
    SpellParam<Entity> target;

    public FocusSpiritTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam((SpellParam)this.target);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
        meta.addStat(EnumSpellStat.POTENCY, 50);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = (Entity)this.getNonnullParamValue(context, this.target);
        if (!(targetVal instanceof SpiritEntity) || ((SpiritEntity)targetVal).getOwner() != context.caster.m_20148_()) {
            Errors.invalidTarget.runtime();
        }
        context.customData.computeIfAbsent(originalFocus, k -> context.focalPoint);
        context.focalPoint = targetVal;
        return context.focalPoint;
    }

    public Class<?> getEvaluationType() {
        return Entity.class;
    }
}

