/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.spirit;

import gdavid.phi.entity.SpiritEntity;
import gdavid.phi.spell.Errors;
import gdavid.phi.util.ParamHelper;
import net.minecraft.world.entity.Entity;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class MoveSpiritTrick
extends PieceTrick {
    SpellParam<Entity> target;
    SpellParam<Vector3> direction;
    SpellParam<Number> distance;

    public MoveSpiritTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, true, false);
        this.addParam((SpellParam)this.target);
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.direction);
        this.distance = new ParamNumber("psi.spellparam.distance", SpellParam.RED, false, true);
        this.addParam((SpellParam)this.distance);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double dist = ParamHelper.positive((SpellPiece)this, this.distance);
        meta.addStat(EnumSpellStat.POTENCY, (int)(dist * 50.0));
        meta.addStat(EnumSpellStat.COST, (int)(dist * 50.0));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = context.focalPoint;
        if (((SpellParam.Side)this.paramSides.get(this.target)).isEnabled()) {
            targetVal = (Entity)this.getNonnullParamValue(context, this.target);
        }
        Vector3 position = ParamHelper.nonNull((SpellPiece)this, context, this.direction).copy().normalize().multiply(((Number)this.getNonnullParamValue(context, this.distance)).doubleValue()).add(Vector3.fromEntity((Entity)targetVal));
        if (!(targetVal instanceof SpiritEntity) || ((SpiritEntity)targetVal).getOwner() != context.caster.m_20148_()) {
            Errors.invalidTarget.runtime();
        }
        targetVal.m_6034_(position.x, position.y, position.z);
        return null;
    }
}

