/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.util;

import gdavid.phi.spell.param.ReferenceParam;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import vazkii.psi.api.spell.CompiledSpell;
import vazkii.psi.api.spell.IErrorCatcher;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;

public class EvalHelper {
    public static boolean isLoop(SpellPiece piece) {
        return EvalHelper.isLoop(piece, new HashSet<SpellPiece>());
    }

    public static boolean isLoop(SpellPiece piece, Set<SpellPiece> visited) {
        if (piece == null) {
            return false;
        }
        if (visited.contains(piece)) {
            return true;
        }
        visited.add(piece);
        for (Map.Entry param : piece.paramSides.entrySet()) {
            if (param.getKey() instanceof ReferenceParam && !((ReferenceParam)((Object)param.getKey())).checkLoop || !((SpellParam.Side)param.getValue()).isEnabled()) continue;
            try {
                SpellPiece other = piece.spell.grid.getPieceAtSideWithRedirections(piece.x, piece.y, (SpellParam.Side)param.getValue());
                if (!EvalHelper.isLoop(other, new HashSet<SpellPiece>(visited))) continue;
                return true;
            }
            catch (SpellCompilationException e) {
                return true;
            }
        }
        return false;
    }

    public static void hoist(SpellPiece piece, SpellContext context) throws SpellCompilationException {
        Optional<CompiledSpell.Action> opt = context.actions.stream().filter(action -> action.piece == piece).findFirst();
        if (!opt.isPresent()) {
            return;
        }
        context.actions.remove(opt.get());
        context.actions.push(opt.get());
        EvalHelper.hoistParams(piece, context);
    }

    public static void reevaluate(SpellPiece piece, SpellContext context) throws SpellCompilationException {
        Stack stack = context.actions;
        CompiledSpell compiledSpell = context.cspell;
        Objects.requireNonNull(compiledSpell);
        stack.push(new CompiledSpell.Action(compiledSpell, piece));
        EvalHelper.hoistParams(piece, context);
    }

    public static void hoistParams(SpellPiece piece, SpellContext context) throws SpellCompilationException {
        CompiledSpell.CatchHandler catchHandler = (CompiledSpell.CatchHandler)context.cspell.errorHandlers.get(piece);
        if (catchHandler != null) {
            EvalHelper.hoist(catchHandler.handlerPiece, context);
        }
        for (Map.Entry param : piece.paramSides.entrySet()) {
            if (!((SpellParam.Side)param.getValue()).isEnabled() || param.getKey() instanceof ReferenceParam || piece instanceof IErrorCatcher && ((IErrorCatcher)piece).catchParam((SpellParam)param.getKey())) continue;
            EvalHelper.hoist(context.cspell.sourceSpell.grid.getPieceAtSideWithRedirections(piece.x, piece.y, (SpellParam.Side)param.getValue()), context);
        }
    }
}

