/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.util;

import gdavid.phi.spell.Errors;
import gdavid.phi.spell.param.ReferenceParam;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;

public class ParamHelper {
    public static double positiveOrZero(SpellPiece piece, SpellParam<Number> param) throws SpellCompilationException {
        double res = ((Number)piece.getNonNullParamEvaluation(param)).doubleValue();
        if (res < 0.0) {
            Errors.compile("psi.spellerror.nonpositivevalue", piece.x, piece.y);
        }
        return res;
    }

    public static double positive(SpellPiece piece, SpellParam<Number> param) throws SpellCompilationException {
        double res = ((Number)piece.getNonNullParamEvaluation(param)).doubleValue();
        if (res <= 0.0) {
            Errors.compile("psi.spellerror.nonpositivevalue", piece.x, piece.y);
        }
        return res;
    }

    public static Vector3 nonNull(SpellPiece piece, SpellContext context, SpellParam<Vector3> param) throws SpellRuntimeException {
        Vector3 res = (Vector3)piece.getNonnullParamValue(context, param);
        if (res.isZero()) {
            Errors.runtime("psi.spellerror.nullvector");
        }
        return res;
    }

    public static Vector3 inRange(SpellPiece piece, SpellContext context, SpellParam<Vector3> param) throws SpellRuntimeException {
        Vector3 res = ParamHelper.nonNull(piece, context, param);
        if (!context.isInRadius(res)) {
            Errors.runtime("psi.spellerror.outsideradius");
        }
        return res;
    }

    public static BlockPos block(SpellPiece piece, SpellContext context, SpellParam<Vector3> param) throws SpellRuntimeException {
        return ParamHelper.inRange(piece, context, param).toBlockPos();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int connectorColor(SpellPiece piece, SpellParam.Side side, int def) {
        return def;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void outputTooltip(SpellPiece piece, Consumer<List<Component>> superFn, List<Component> tooltip) {
        HashMap paramSidesTmp = new HashMap(piece.paramSides);
        piece.paramSides.keySet().removeIf(e -> e instanceof ReferenceParam && ((ReferenceParam)e).isOutput);
        superFn.accept(tooltip);
        piece.paramSides.putAll(paramSidesTmp);
        for (SpellParam param : piece.paramSides.keySet()) {
            if (!(param instanceof ReferenceParam) || !((ReferenceParam)param).isOutput) continue;
            MutableComponent name = Component.m_237115_((String)param.name).m_130940_(ChatFormatting.YELLOW);
            MutableComponent type = Component.m_237113_((String)" [").m_7220_(param.getRequiredTypeString()).m_130946_("]").m_130940_(ChatFormatting.YELLOW);
            tooltip.add((Component)Component.m_237113_((String)(param.canDisable ? "[Output] " : " Output  ")).m_7220_((Component)name).m_7220_((Component)type));
        }
    }
}

