/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.util;

import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.api.spell.SpellPiece;

public class SpellCachedView<T> {
    private final SpellPiece owner;
    private UUID lastSpellUUID = null;
    private final Supplier<? extends T> supplier;
    private final Supplier<? extends T> fallbackSupplier;
    private boolean updating = false;
    private T value;

    public SpellCachedView(@NotNull SpellPiece owner, @NotNull Supplier<? extends T> supplier) {
        this(owner, supplier, () -> {
            throw new SelfReferentialException(owner);
        });
    }

    public SpellCachedView(@NotNull SpellPiece owner, @NotNull Supplier<? extends T> supplier, @NotNull Supplier<? extends T> fallbackSupplier) {
        this.owner = owner;
        this.supplier = supplier;
        this.fallbackSupplier = fallbackSupplier;
    }

    public T get() throws SelfReferentialException {
        if (this.lastSpellUUID == null || !this.lastSpellUUID.equals(this.owner.spell.uuid)) {
            if (this.updating) {
                return this.fallbackSupplier.get();
            }
            this.updating = true;
            this.value = this.supplier.get();
            this.lastSpellUUID = this.owner.spell.uuid;
            this.updating = false;
        }
        return this.value;
    }

    public static class SelfReferentialException
    extends IllegalStateException {
        public final SpellPiece piece;

        public SelfReferentialException(SpellPiece owner) {
            super("Self-referential SpellCachedView evaluation in " + String.valueOf(owner));
            this.piece = owner;
        }
    }
}

