/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.hayato08.udonmod.Config;
import net.hayato08.udonmod.block.UdonBlocks;
import net.hayato08.udonmod.block.entity.UdonBlockEntities;
import net.hayato08.udonmod.client.gui.UdonMenuTypes;
import net.hayato08.udonmod.client.gui.UniversalCookingBlockScreen;
import net.hayato08.udonmod.entity.UdonEntities;
import net.hayato08.udonmod.entity.UdonEntityAttributes;
import net.hayato08.udonmod.events.WolFoxEventHandler;
import net.hayato08.udonmod.init.UdonModMenus;
import net.hayato08.udonmod.item.UdonCreativeModeTabs;
import net.hayato08.udonmod.item.UdonItems;
import net.hayato08.udonmod.item.armor.BukkakeArmorAttackNegation;
import net.hayato08.udonmod.item.katana.KitsuneKatanaItem;
import net.hayato08.udonmod.particle.GraySplashParticle;
import net.hayato08.udonmod.particle.UdonParticles;
import net.hayato08.udonmod.recipe.UdonRecipes;
import net.hayato08.udonmod.sound.UdonSounds;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="udonmod")
public class UdonMod {
    public static final String MOD_ID = "udonmod";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public UdonMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerNetworking);
        modEventBus.register(UdonEntityAttributes.class);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register(WolFoxEventHandler.class);
        NeoForge.EVENT_BUS.register(BukkakeArmorAttackNegation.class);
        UdonCreativeModeTabs.register(modEventBus);
        UdonItems.register(modEventBus);
        UdonBlocks.register(modEventBus);
        UdonModMenus.register(modEventBus);
        UdonSounds.register(modEventBus);
        UdonEntities.register(modEventBus);
        UdonParticles.register(modEventBus);
        UdonBlockEntities.register(modEventBus);
        UdonMenuTypes.register(modEventBus);
        UdonRecipes.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MOD_ID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(UdonItems.FLOUR);
            event.accept(UdonItems.DASHI);
            event.accept(UdonItems.DRY_UDON);
            event.accept(UdonItems.RAW_UDON);
        } else if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            event.accept(UdonItems.BUKKAKE_UDON);
            event.accept(UdonItems.RICH_BUKKAKE_UDON);
            event.accept(UdonItems.CURRY_UDON);
            event.accept(UdonItems.RICH_CURRY_UDON);
            event.accept(UdonItems.COLD_UDON);
            event.accept(UdonItems.RICH_COLD_UDON);
            event.accept(UdonItems.KITSUNE_UDON);
            event.accept(UdonItems.RICH_KITSUNE_UDON);
            event.accept(UdonItems.ZARU_UDON);
            event.accept(UdonItems.RICH_ZARU_UDON);
        } else if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept(UdonBlocks.STONE_MILL);
        } else if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept((ItemLike)UdonItems.WOLFOX_SPAWN_EGG.get());
            event.accept((ItemLike)UdonItems.KATSUO_SPWAN_EGG.get());
            event.accept((ItemLike)UdonItems.IWASHI_SPAWN_EGG.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        KitsuneKatanaItem.onServerTick(event);
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }

    @EventBusSubscriber(modid="udonmod", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)UdonParticles.GRAY_SPLASH.get(), GraySplashParticle.Provider::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)UdonMenuTypes.UNIVERSAL_COOKING_BLOCK_MENU.get(), UniversalCookingBlockScreen::new);
        }
    }
}

