/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.block;

import java.util.function.Supplier;
import net.hayato08.udonmod.block.custom.StoneMillBlock;
import net.hayato08.udonmod.block.custom.UniversalCookingBlock;
import net.hayato08.udonmod.item.UdonItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class UdonBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"udonmod");
    public static final DeferredBlock<Block> STONE_MILL = UdonBlocks.registerBlock("stone_mill", () -> new StoneMillBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> UNIVERSAL_COOKING_BLOCK = UdonBlocks.registerBlock("universal_cooking_block", () -> new UniversalCookingBlock(BlockBehaviour.Properties.of().strength(4.0f).sound(SoundType.WOOD)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        UdonBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    public static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        UdonItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

