/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.block.entity;

import java.util.Optional;
import net.hayato08.udonmod.block.entity.UdonBlockEntities;
import net.hayato08.udonmod.client.gui.UniversalCookingBlockMenu;
import net.hayato08.udonmod.recipe.UdonRecipes;
import net.hayato08.udonmod.recipe.UniversalCookingBlockRecipe;
import net.hayato08.udonmod.recipe.UniversalCookingBlockRecipeInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class UniversalCookingBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int SLOT_COUNT = 2;
    private static final int INPUT_SLOT_0 = 0;
    private static final int OUTPUT_SLOT_1 = 1;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 72;
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            UniversalCookingBlockEntity.this.setChanged();
            if (!((UniversalCookingBlockEntity)UniversalCookingBlockEntity.this).level.isClientSide) {
                UniversalCookingBlockEntity.this.level.sendBlockUpdated(UniversalCookingBlockEntity.this.getBlockPos(), UniversalCookingBlockEntity.this.getBlockState(), UniversalCookingBlockEntity.this.getBlockState(), 3);
            }
        }
    };

    public UniversalCookingBlockEntity(BlockPos pos, BlockState blockState) {
        super(UdonBlockEntities.UNIVERSAL_COOKING_BLOCK_ENTITY.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> UniversalCookingBlockEntity.this.progress;
                    case 1 -> UniversalCookingBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        UniversalCookingBlockEntity.this.progress = value;
                    }
                    case 1: {
                        UniversalCookingBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.udonmod.universal_cooking_block");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new UniversalCookingBlockMenu(i, inventory, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("universal_cooking_block.progress", this.progress);
        tag.putInt("universal_cooking_block.max_progress", this.maxProgress);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        this.progress = tag.getInt("universal_cooking_block.progress");
        this.maxProgress = tag.getInt("universal_cooking_block.max_progress");
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (this.hasResipe()) {
            this.intcreaseCraftingProgress();
            UniversalCookingBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 72;
    }

    private void craftItem() {
        Optional<RecipeHolder<UniversalCookingBlockRecipe>> recipe = this.getCurentRecipe();
        ItemStack output = ((UniversalCookingBlockRecipe)recipe.get().value()).output();
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)output.getItem(), this.itemHandler.getStackInSlot(1).getCount() + output.getCount()));
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void intcreaseCraftingProgress() {
        ++this.progress;
    }

    private boolean hasResipe() {
        Optional<RecipeHolder<UniversalCookingBlockRecipe>> recipe = this.getCurentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = ((UniversalCookingBlockRecipe)recipe.get().value()).output();
        return this.canInsertAmountIntoOutputSlot(output.getCount()) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<UniversalCookingBlockRecipe>> getCurentRecipe() {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)UdonRecipes.UNIVERSAL_COOKING_BLOCK_TYPE.get(), (RecipeInput)new UniversalCookingBlockRecipeInput(this.itemHandler.getStackInSlot(0)), this.level);
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.itemHandler.getStackInSlot(1).isEmpty() || this.itemHandler.getStackInSlot(1).getItem() == output.getItem();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.itemHandler.getStackInSlot(1).isEmpty() ? 64 : this.itemHandler.getStackInSlot(1).getMaxStackSize();
        int currentCount = this.itemHandler.getStackInSlot(1).getCount();
        return maxCount >= currentCount + count;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return super.getUpdateTag(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return super.getUpdatePacket();
    }
}

