/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.client.renderer;

import net.hayato08.udonmod.client.model.KatsuoMobModel;
import net.hayato08.udonmod.client.model.animations.KatsuoAnimation;
import net.hayato08.udonmod.entity.custom.KatsuoEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class KatsuoRenderer
extends MobRenderer<KatsuoEntity, KatsuoMobModel<KatsuoEntity>> {
    public KatsuoRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(KatsuoMobModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(KatsuoEntity entity) {
        return ResourceLocation.parse((String)"udonmod:textures/entities/katsuo.png");
    }

    private static final class AnimatedModel
    extends KatsuoMobModel<KatsuoEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<KatsuoEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(KatsuoEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, KatsuoAnimation.swim, ageInTicks, 1.0f);
                this.animate(entity.animationState1, KatsuoAnimation.stop, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(KatsuoEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

