/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.detagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.hayato08.udonmod.detagen.ItemRecipelProvider;
import net.hayato08.udonmod.detagen.UdonBlockLootTableProvider;
import net.hayato08.udonmod.detagen.UdonBlockStateProvider;
import net.hayato08.udonmod.detagen.UdonBlockTagProvider;
import net.hayato08.udonmod.detagen.UdonDataMapProvider;
import net.hayato08.udonmod.detagen.UdonItemModelProvider;
import net.hayato08.udonmod.detagen.UdonItemTagProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="udonmod", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(UdonBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        UdonBlockTagProvider blockTagsProvider = new UdonBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new UdonItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemRecipelProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new UdonDataMapProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeDev(), (DataProvider)new UdonItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeDev(), (DataProvider)new UdonBlockStateProvider(packOutput, existingFileHelper));
    }
}

