/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.hayato08.udonmod.entity.custom.WolFoxEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class WolFoxModel<T extends WolFoxEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"udonmod", (String)"wolfox"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart tail;

    public WolFoxModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leg1 = root.getChild("right_hind_leg");
        this.leg2 = root.getChild("left_hind_leg");
        this.leg3 = root.getChild("right_front_leg");
        this.leg4 = root.getChild("left_front_leg");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(24, 15).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(1, 5).addBox(-4.0f, -2.0f, -6.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(8, 1).addBox(-4.0f, -4.0f, -5.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(15, 1).addBox(2.0f, -4.0f, -5.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(6, 18).addBox(-2.0f, 2.0f, -9.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.0f, (float)-3.0f));
        PartDefinition leg0 = partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(13, 24).addBox(-0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)18.0f, (float)6.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(4, 24).addBox(0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)18.0f, (float)6.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(13, 24).addBox(-0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)18.0f, (float)-1.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(4, 24).addBox(0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)18.0f, (float)-1.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(30, 0).addBox(-2.0f, 1.0f, -2.25f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)7.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)48, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.leg1.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg4.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.tail.yRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.1f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int i1, int i2) {
        this.head.render(poseStack, vertexConsumer, i, i1, i2);
        this.body.render(poseStack, vertexConsumer, i, i1, i2);
        this.leg1.render(poseStack, vertexConsumer, i, i1, i2);
        this.leg2.render(poseStack, vertexConsumer, i, i1, i2);
        this.leg3.render(poseStack, vertexConsumer, i, i1, i2);
        this.leg4.render(poseStack, vertexConsumer, i, i1, i2);
        this.tail.render(poseStack, vertexConsumer, i, i1, i2);
    }
}

