/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.item.armor;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.hayato08.udonmod.item.armor.KitsuneArmorItem;
import net.hayato08.udonmod.item.armor.UdonArmorMaterials;
import net.hayato08.udonmod.item.armor.ZaruArmorItem;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class UdonArmorItem
extends ArmorItem {
    private static final double FIRE_RADIUS = 8.0;
    private static final int FIRE_SECONDS = 15;
    private static final Map<Holder<ArmorMaterial>, List<MobEffectInstance>> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put(KitsuneArmorItem.KITSUNE_ARMOR_MATERIAL, List.of(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, 1, false, false))).put(UdonArmorMaterials.COLD_ARMOR_MATERIAL, List.of(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 1, false, false))).put(ZaruArmorItem.ZARU_ARMOR_MATERIAL, List.of(new MobEffectInstance(MobEffects.DIG_SPEED, 200, 1, false, false))).build();

    public UdonArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide() && this.hasFullSuitOfArmorOn(player)) {
                this.evaluateArmorEffects(player);
                if (this.hasPlayerCorrectArmorOn(UdonArmorMaterials.CURRY_ARMOR_MATERIAL, player)) {
                    level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(8.0)).stream().filter(e -> e instanceof Monster).forEach(e -> e.setRemainingFireTicks(300));
                }
            }
        }
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<Holder<ArmorMaterial>, List<MobEffectInstance>> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            Holder<ArmorMaterial> mapArmorMaterial = entry.getKey();
            List<MobEffectInstance> mapEffect = entry.getValue();
            if (!this.hasPlayerCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addEffectToPlayer(player, mapEffect);
        }
    }

    private void addEffectToPlayer(Player player, List<MobEffectInstance> mapEffect) {
        boolean hasPlayerEffect = mapEffect.stream().allMatch(effect -> player.hasEffect(effect.getEffect()));
        if (!hasPlayerEffect) {
            for (MobEffectInstance effect2 : mapEffect) {
                player.addEffect(new MobEffectInstance(effect2.getEffect(), effect2.getDuration(), effect2.getAmplifier(), effect2.isAmbient(), effect2.isVisible()));
            }
        }
    }

    private boolean hasPlayerCorrectArmorOn(Holder<ArmorMaterial> mapArmorMaterial, Player player) {
        for (ItemStack armorStack : player.getArmorSlots()) {
            if (armorStack.getItem() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.getInventory().getArmor(0).getItem();
        ArmorItem leggings = (ArmorItem)player.getInventory().getArmor(1).getItem();
        ArmorItem chestplate = (ArmorItem)player.getInventory().getArmor(2).getItem();
        ArmorItem helmet = (ArmorItem)player.getInventory().getArmor(3).getItem();
        return boots.getMaterial() == mapArmorMaterial && leggings.getMaterial() == mapArmorMaterial && chestplate.getMaterial() == mapArmorMaterial && helmet.getMaterial() == mapArmorMaterial;
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.getInventory().getArmor(0);
        ItemStack leggings = player.getInventory().getArmor(1);
        ItemStack chestplate = player.getInventory().getArmor(2);
        ItemStack helmet = player.getInventory().getArmor(3);
        return !boots.isEmpty() && !leggings.isEmpty() && !chestplate.isEmpty() && !helmet.isEmpty();
    }
}

