/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.item.armor;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.hayato08.udonmod.item.UdonItems;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class UdonArmorMaterials {
    public static final Holder<ArmorMaterial> CURRY_ARMOR_MATERIAL = UdonArmorMaterials.register("curry", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 3);
        attribute.put(ArmorItem.Type.LEGGINGS, 5);
        attribute.put(ArmorItem.Type.CHESTPLATE, 6);
        attribute.put(ArmorItem.Type.HELMET, 3);
        attribute.put(ArmorItem.Type.BODY, 5);
    }), 9, 1.0f, 0.1f, () -> (Item)UdonItems.CURRY_UDON.get());
    public static final Holder<ArmorMaterial> COLD_ARMOR_MATERIAL = UdonArmorMaterials.register("cold", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 2);
        attribute.put(ArmorItem.Type.LEGGINGS, 5);
        attribute.put(ArmorItem.Type.CHESTPLATE, 6);
        attribute.put(ArmorItem.Type.HELMET, 2);
        attribute.put(ArmorItem.Type.BODY, 5);
    }), 9, 0.0f, 0.0f, () -> (Item)UdonItems.COLD_UDON.get());
    public static final Holder<ArmorMaterial> BUKKAKE_ARMOR_MATERIAL = UdonArmorMaterials.register("bukkake", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 2);
        attribute.put(ArmorItem.Type.LEGGINGS, 5);
        attribute.put(ArmorItem.Type.CHESTPLATE, 6);
        attribute.put(ArmorItem.Type.HELMET, 2);
        attribute.put(ArmorItem.Type.BODY, 5);
    }), 9, 0.0f, 0.0f, () -> (Item)UdonItems.BUKKAKE_UDON.get());

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> typeProtection, int enchantability, float toughness, float knockbackResistance, Supplier<Item> ingredientItem) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"udonmod", (String)name);
        Holder equipSound = SoundEvents.ARMOR_EQUIP_IRON;
        Supplier<Ingredient> ingredient = () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingredientItem.get()});
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(location));
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, typeProtection.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)location, (Object)new ArmorMaterial(typeProtection, enchantability, equipSound, ingredient, layers, toughness, knockbackResistance));
    }
}

