/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.item.katana;

import java.util.List;
import java.util.Random;
import net.hayato08.udonmod.particle.UdonParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BukkakeKatanaItem
extends SwordItem {
    private static final int PARTICLE_COUNT = 80;
    private final Random random = new Random();

    public BukkakeKatanaItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return this.getTier().getEnchantmentValue();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.addEffect(new MobEffectInstance(MobEffects.POISON, 300, 1));
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 position = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
            for (int i = 0; i < 80; ++i) {
                double offsetX = this.random.nextDouble() - 0.5;
                double offsetY = this.random.nextDouble() * 0.5;
                double offsetZ = this.random.nextDouble() - 0.5;
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)UdonParticles.GRAY_SPLASH.get()), position.x + offsetX, position.y + offsetY, position.z + offsetZ, 1, 0.0, 0.1, 0.0, 0.2);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.udonmod.bukkake_katana"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

