/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.item.katana;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ColdKatanaItem
extends SwordItem {
    public ColdKatanaItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return this.getTier().getEnchantmentValue();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.level();
        if (level.dimension() == Level.NETHER) {
            float extraDamage = 15.0f;
            target.hurt(level.damageSources().playerAttack((Player)attacker), extraDamage);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.udonmod.cold_katana"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

