/*
 * Decompiled with CFR 0.152.
 */
package net.hayato08.udonmod.item.katana;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.hayato08.udonmod.entity.UdonEntities;
import net.hayato08.udonmod.entity.custom.WolFoxEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class KitsuneKatanaItem
extends SwordItem {
    private static int foxCounter = 0;
    private static final int DESPAWN_TIME = 300;
    private static final int MAX_FOXES = 5;
    private static final List<WolFoxEntity> spawnedFoxes = new ArrayList<WolFoxEntity>();

    public KitsuneKatanaItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return this.getTier().getEnchantmentValue();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level world = attacker.level();
        if (!world.isClientSide) {
            WolFoxEntity fox;
            spawnedFoxes.removeIf(f -> !f.isAlive());
            if (spawnedFoxes.size() < 5 && (fox = new WolFoxEntity(UdonEntities.WOLFOX.get(), world)) != null) {
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    fox.tame(player);
                }
                fox.setTarget(target);
                CompoundTag data = fox.getPersistentData();
                data.putInt("kitsuneID", foxCounter++);
                long despawnTime = world.getGameTime() + 300L;
                data.putLong("despawnTime", despawnTime);
                fox.moveTo(target.getX(), target.getY(), target.getZ(), target.getYRot(), target.getXRot());
                world.addFreshEntity((Entity)fox);
                spawnedFoxes.add(fox);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        Iterator<WolFoxEntity> iterator = spawnedFoxes.iterator();
        while (iterator.hasNext()) {
            WolFoxEntity fox = iterator.next();
            if (!fox.isAlive()) {
                iterator.remove();
                continue;
            }
            CompoundTag data = fox.getPersistentData();
            long despawnTime = data.getLong("despawnTime");
            if (fox.level().getGameTime() < despawnTime) continue;
            fox.remove(Entity.RemovalReason.DISCARDED);
            iterator.remove();
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.udonmod.kitsune_katana"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

